/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Base64;

public final class URLUtils {
    private static final int MD5_BUFFER_SIZE = 8192;
    private static final int HEX_RADIX = 16;

    private URLUtils() {
    }

    public static URL buildUrl(String context, String ... relocations) {
        try {
            return URLUtils.buildUrl(new URL(context), relocations);
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)("URL('" + context + "') isn't valid URL"));
        }
    }

    public static URL buildUrl(URL context, String ... relocations) {
        URL url = context;
        for (String move : relocations) {
            try {
                url = new URL(url, move);
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)("URL('" + url + "', '" + move + "') isn't valid URL"));
            }
        }
        return url;
    }

    public static String resourceMd5Digest(String url) throws IOException {
        MessageDigest digest;
        URLConnection connection = new URL(url).openConnection();
        InputStream in = connection.getInputStream();
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException("MD5 hashing is unsupported", ex);
        }
        byte[] buffer = new byte[8192];
        int read = 0;
        while ((read = in.read(buffer)) > 0) {
            digest.update(buffer, 0, read);
        }
        byte[] md5sum = digest.digest();
        BigInteger bigInt = new BigInteger(1, md5sum);
        return bigInt.toString(16);
    }

    public static String encodeBase64Credentials(String username, String password) {
        String credentials = username + ":" + password;
        try {
            String defaultCharsetName = Charset.defaultCharset().displayName();
            byte[] credentialsAsBytes = credentials.getBytes(defaultCharsetName);
            byte[] encodedCredentials = Base64.encodeBase64((byte[])credentialsAsBytes);
            return new String(encodedCredentials, defaultCharsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }
}

