/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.waiting;

import org.jboss.arquillian.ajocado.waiting.WaitTimeoutException;
import org.jboss.arquillian.ajocado.waiting.Waiting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultWaiting<T extends Waiting<T>>
implements Waiting<T>,
Cloneable {
    private boolean isDelayed = true;
    private long interval = 500L;
    private long timeout = 30000L;
    private Object failure = "Waiting timed out";
    private Object[] failureArgs;

    protected long getInterval() {
        return this.interval;
    }

    protected long getTimeout() {
        return this.timeout;
    }

    protected boolean isDelayed() {
        return this.isDelayed;
    }

    @Override
    public T interval(long interval) {
        if (interval == this.interval) {
            return (T)this;
        }
        DefaultWaiting copy = (DefaultWaiting)this.copy();
        copy.interval = interval;
        return (T)copy;
    }

    @Override
    public T timeout(long timeout) {
        if (timeout == this.timeout) {
            return (T)this;
        }
        DefaultWaiting copy = (DefaultWaiting)this.copy();
        copy.timeout = timeout;
        return (T)copy;
    }

    @Override
    public T failWith(Exception exception) {
        if (exception == null && this.failure == null) {
            return (T)this;
        }
        DefaultWaiting copy = (DefaultWaiting)this.copy();
        copy.failure = exception;
        copy.failureArgs = null;
        return (T)copy;
    }

    @Override
    public T failWith(CharSequence failureMessage, Object ... arguments) {
        DefaultWaiting copy = (DefaultWaiting)this.copy();
        copy.failure = failureMessage;
        copy.failureArgs = arguments;
        return (T)copy;
    }

    @Override
    public T dontFail() {
        return this.failWith(null);
    }

    @Override
    public T noDelay() {
        return this.withDelay(false);
    }

    @Override
    public T withDelay(boolean isDelayed) {
        if (isDelayed == this.isDelayed) {
            return (T)this;
        }
        DefaultWaiting copy = (DefaultWaiting)this.copy();
        copy.isDelayed = isDelayed;
        return (T)copy;
    }

    @Override
    public void waitForTimeout() {
        try {
            Thread.sleep(this.timeout);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected void fail() {
        if (this.failure != null) {
            throw this.prepareFailure();
        }
    }

    private RuntimeException prepareFailure() {
        if (this.failure instanceof RuntimeException) {
            return (RuntimeException)this.failure;
        }
        if (this.failure instanceof CharSequence) {
            return new WaitTimeoutException((CharSequence)this.failure, this.failureArgs);
        }
        return new WaitTimeoutException((Exception)this.failure);
    }

    private T copy() {
        try {
            return (T)((Waiting)this.clone());
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }
}

