/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene;

import org.jboss.arquillian.graphene.condition.AttributeConditionFactory;
import org.jboss.arquillian.graphene.condition.ElementConditionFactory;
import org.jboss.arquillian.graphene.condition.attribute.AttributeConditionFactoryImpl;
import org.jboss.arquillian.graphene.condition.element.WebElementConditionFactory;
import org.jboss.arquillian.graphene.condition.locator.ElementLocatorConditionFactory;
import org.jboss.arquillian.graphene.configuration.GrapheneConfiguration;
import org.jboss.arquillian.graphene.context.GrapheneConfigurationContext;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.guard.RequestGuardFactory;
import org.jboss.arquillian.graphene.page.RequestType;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.WebDriverWait;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graphene {
    public static AttributeConditionFactory attribute(WebElement element, String attribute) {
        return new AttributeConditionFactoryImpl(element, attribute);
    }

    public static ElementConditionFactory element(WebElement element) {
        return new WebElementConditionFactory(element);
    }

    public static ElementConditionFactory element(By locator) {
        return new ElementLocatorConditionFactory(locator);
    }

    public static <T> T guardHttp(T target) {
        return RequestGuardFactory.guard(target, RequestType.HTTP);
    }

    public static <T> T guardNoRequest(T target) {
        return RequestGuardFactory.guard(target, RequestType.NONE);
    }

    public static <T> T guardXhr(T target) {
        return RequestGuardFactory.guard(target, RequestType.XHR);
    }

    public static WebDriverWait waitAjax() {
        return Graphene.waitAjax(GrapheneContext.getProxy());
    }

    public static WebDriverWait waitAjax(WebDriver driver) {
        return new WebDriverWait(driver, Graphene.getConfiguration().getWaitAjaxInterval());
    }

    public static WebDriverWait waitGui() {
        return Graphene.waitGui(GrapheneContext.getProxy());
    }

    public static WebDriverWait waitGui(WebDriver driver) {
        return new WebDriverWait(driver, Graphene.getConfiguration().getWaitGuiInterval());
    }

    public static WebDriverWait waitModel() {
        return Graphene.waitModel(GrapheneContext.getProxy());
    }

    public static WebDriverWait waitModel(WebDriver driver) {
        return new WebDriverWait(driver, Graphene.getConfiguration().getWaitModelInterval());
    }

    private static GrapheneConfiguration getConfiguration() {
        return GrapheneConfigurationContext.getProxy();
    }
}

