/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.condition;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jboss.logging.Logger;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanConditionWrapper
implements ExpectedCondition<Boolean> {
    private final ExpectedCondition<?> wrapped;
    private final boolean negation;
    private final Set<Class<? extends RuntimeException>> ignoredExceptions = new HashSet<Class<? extends RuntimeException>>();
    protected static final Logger LOGGER = Logger.getLogger(BooleanConditionWrapper.class);

    public BooleanConditionWrapper(ExpectedCondition<?> wrapped, Class<? extends RuntimeException> ... ignoredExceptions) {
        this(wrapped, false, ignoredExceptions);
    }

    public BooleanConditionWrapper(ExpectedCondition<?> wrapped, boolean negation, Class<? extends RuntimeException> ... ignoredExceptions) {
        if (wrapped == null) {
            throw new IllegalArgumentException("The wrapped is null.");
        }
        this.wrapped = wrapped;
        this.negation = negation;
        this.ignoredExceptions.addAll(Arrays.asList(ignoredExceptions));
    }

    public Boolean apply(WebDriver driver) {
        try {
            Object original = this.wrapped.apply((Object)driver);
            if (original instanceof Boolean) {
                if (this.negation) {
                    return (Boolean)original == false;
                }
                return (Boolean)original;
            }
            if (this.negation) {
                return original == null;
            }
            return original != null;
        }
        catch (StaleElementReferenceException ignored) {
            LOGGER.debug((Object)"The element is stale.", (Throwable)ignored);
            return false;
        }
        catch (RuntimeException e) {
            if (this.ignoredExceptions.contains(e.getClass())) {
                LOGGER.debug((Object)("Exception ignored, returning " + this.negation + "."), (Throwable)e);
                return this.negation;
            }
            throw e;
        }
    }
}

