/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.condition.locator;

import org.jboss.arquillian.graphene.condition.AbstractBooleanConditionFactory;
import org.jboss.arquillian.graphene.condition.BooleanConditionWrapper;
import org.jboss.arquillian.graphene.condition.ElementConditionFactory;
import org.jboss.logging.Logger;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementLocatorConditionFactory
extends AbstractBooleanConditionFactory<ElementConditionFactory>
implements ElementConditionFactory {
    private final By locator;
    protected static final Logger LOGGER = Logger.getLogger(ElementConditionFactory.class);

    public ElementLocatorConditionFactory(By locator) {
        if (locator == null) {
            throw new IllegalArgumentException("The locator can't be null.");
        }
        this.locator = locator;
    }

    @Override
    public ExpectedCondition<Boolean> isVisible() {
        return new BooleanConditionWrapper(ExpectedConditions.visibilityOfElementLocated((By)this.locator), this.getNegation(), NoSuchElementException.class);
    }

    @Override
    public ExpectedCondition<Boolean> isPresent() {
        return new BooleanConditionWrapper(ExpectedConditions.presenceOfElementLocated((By)this.locator), this.getNegation(), NoSuchElementException.class);
    }

    @Override
    public ExpectedCondition<Boolean> isSelected() {
        return ExpectedConditions.elementSelectionStateToBe((By)this.locator, (!this.getNegation() ? 1 : 0) != 0);
    }

    @Override
    public ExpectedCondition<Boolean> textContains(String expected) {
        return new BooleanConditionWrapper(ExpectedConditions.textToBePresentInElement((By)this.locator, (String)expected), this.getNegation(), new Class[0]);
    }

    @Override
    public ExpectedCondition<Boolean> textEquals(final String expected) {
        if (expected == null) {
            throw new IllegalArgumentException("The expected string is null.");
        }
        return new BooleanConditionWrapper(new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                String elementText = ElementLocatorConditionFactory.findElement(ElementLocatorConditionFactory.this.locator, driver).getText();
                return expected.equals(elementText);
            }
        }, this.getNegation(), new Class[0]);
    }

    @Override
    protected ElementConditionFactory copy() {
        ElementLocatorConditionFactory copy = new ElementLocatorConditionFactory(this.locator);
        copy.setNegation(this.getNegation());
        return copy;
    }

    private static WebElement findElement(By by, WebDriver driver) {
        try {
            return driver.findElement(by);
        }
        catch (NoSuchElementException e) {
            throw e;
        }
        catch (WebDriverException e) {
            LOGGER.debug((Object)String.format("WebDriverException thrown by findElement(%s)", by), (Throwable)e);
            throw e;
        }
    }
}

