/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.javascript;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.jboss.arquillian.graphene.javascript.JSInterfaceHandler;
import org.jboss.arquillian.graphene.javascript.JSTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSInterfaceFactory<T> {
    private JSInterfaceHandler handler;

    private JSInterfaceFactory(Class<T> jsInterface) {
        if (!jsInterface.isInterface()) {
            throw new IllegalArgumentException("interface must be provided");
        }
        this.handler = new JSInterfaceHandler(new JSTarget(jsInterface));
    }

    public static <T> T create(Class<T> jsInterface) {
        return new JSInterfaceFactory<T>(jsInterface).instantiate();
    }

    public T instantiate() {
        Class<?> jsInterface = this.handler.getTarget().getInterface();
        return (T)Proxy.newProxyInstance(jsInterface.getClassLoader(), new Class[]{jsInterface}, (InvocationHandler)this.handler);
    }
}

