/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.page.extension;

import org.apache.commons.lang.Validate;
import org.jboss.arquillian.graphene.page.extension.AbstractPageExtensionInstallator;
import org.jboss.arquillian.graphene.page.extension.AbstractPageExtensionInstallatorProvider;
import org.jboss.arquillian.graphene.page.extension.PageExtensionInstallator;
import org.jboss.arquillian.graphene.page.extension.PageExtensionRegistry;
import org.jboss.arquillian.graphene.spi.page.PageExtension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

public class RemotePageExtensionInstallatorProvider
extends AbstractPageExtensionInstallatorProvider {
    private final WebDriver driver;

    public RemotePageExtensionInstallatorProvider(PageExtensionRegistry registry, WebDriver driver) {
        super(registry);
        Validate.notNull((Object)driver);
        this.driver = driver;
        if (!(driver instanceof JavascriptExecutor)) {
            throw new IllegalStateException("Can't use the given driver to execute javascript, because it doesn't implement " + JavascriptExecutor.class + " interface.");
        }
    }

    public PageExtensionInstallator createInstallator(final PageExtension extension) {
        return new AbstractPageExtensionInstallator(extension, this){

            protected void installWithoutRequirements() {
                ((JavascriptExecutor)RemotePageExtensionInstallatorProvider.this.driver).executeScript(extension.getExtensionScript().getSourceCode(), new Object[0]);
            }

            public boolean isInstalled() {
                Object result = ((JavascriptExecutor)RemotePageExtensionInstallatorProvider.this.driver).executeScript(extension.getInstallationDetectionScript().getSourceCode(), new Object[0]);
                if (!(result instanceof Boolean)) {
                    throw new IllegalStateException("The result of installation detection script is not boolean as expected, " + result + " given.");
                }
                return (Boolean)result;
            }
        };
    }
}

