/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.jboss.arquillian.core.spi.LoadableExtension;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.proxy.GrapheneProxy;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.jboss.arquillian.graphene.proxy.Interceptor;
import org.jboss.arquillian.graphene.proxy.InvocationContext;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.test.spi.enricher.resource.ResourceProvider;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.HasInputDevices;
import org.openqa.selenium.HasTouchScreen;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keyboard;
import org.openqa.selenium.Mouse;
import org.openqa.selenium.Rotatable;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.TouchScreen;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.html5.ApplicationCache;
import org.openqa.selenium.html5.BrowserConnection;
import org.openqa.selenium.html5.DatabaseStorage;
import org.openqa.selenium.html5.LocationContext;
import org.openqa.selenium.html5.WebStorage;
import org.openqa.selenium.interactions.Actions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SeleniumResourceProvider<T>
implements ResourceProvider {
    protected Class<?> mediatorType;
    protected Class<?> returnType = this.getTypeArgument(0);

    public SeleniumResourceProvider() {
        this.mediatorType = this.returnType;
    }

    public boolean canProvide(Class<?> type) {
        return type == this.returnType;
    }

    protected <BASE> BASE base() {
        return (BASE)GrapheneContext.getProxyForInterfaces(this.mediatorType);
    }

    protected Class<?> getTypeArgument(int i) {
        ParameterizedType superType = (ParameterizedType)this.getClass().getGenericSuperclass();
        Type[] typeArguments = superType.getActualTypeArguments();
        return (Class)typeArguments[i];
    }

    public static void registerAllProviders(LoadableExtension.ExtensionBuilder builder) {
        for (Class<?> clazz : SeleniumResourceProvider.class.getClasses()) {
            if (!SeleniumResourceProvider.class.isAssignableFrom(clazz)) continue;
            builder.service(ResourceProvider.class, clazz);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class IndirectProvider<T, M>
    extends SeleniumResourceProvider<T> {
        public IndirectProvider() {
            this.mediatorType = this.getTypeArgument(1);
        }

        public Object lookup(ArquillianResource resource, Annotation ... qualifiers) {
            final Object base = this.base();
            ((GrapheneProxyInstance)base).registerInterceptor(new Interceptor(){

                public Object intercept(final InvocationContext context) throws Throwable {
                    final Method method = context.getMethod();
                    if (method.getDeclaringClass() == IndirectProvider.this.mediatorType) {
                        return GrapheneProxy.getProxyForFutureTarget(new GrapheneProxy.FutureTarget(){

                            public Object getTarget() {
                                try {
                                    Object unwrappedBase = ((GrapheneProxyInstance)base).unwrap();
                                    return method.invoke(unwrappedBase, context.getArguments());
                                }
                                catch (Exception e) {
                                    throw new IllegalStateException(e);
                                }
                            }
                        }, method.getReturnType(), new Class[0]);
                    }
                    throw new IllegalStateException("You cannot invoke method " + method + " on the " + IndirectProvider.this.mediatorType);
                }
            });
            return this.invoke(base);
        }

        public abstract T invoke(M var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DirectProvider<T>
    extends SeleniumResourceProvider<T> {
        private DirectProvider() {
        }

        public T lookup(ArquillianResource resource, Annotation ... qualifiers) {
            return (T)this.base();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ActionsProvider
    extends IndirectProvider<Actions, HasInputDevices> {
        @Override
        public Actions invoke(HasInputDevices base) {
            Keyboard keyboard = base.getKeyboard();
            Mouse mouse = base.getMouse();
            return new Actions(keyboard, mouse);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TouchScreenProvider
    extends IndirectProvider<TouchScreen, HasTouchScreen> {
        @Override
        public TouchScreen invoke(HasTouchScreen base) {
            return base.getTouch();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CapabilitiesProvider
    extends IndirectProvider<Capabilities, HasCapabilities> {
        @Override
        public Capabilities invoke(HasCapabilities base) {
            return base.getCapabilities();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MouseProvider
    extends IndirectProvider<Mouse, HasInputDevices> {
        @Override
        public Mouse invoke(HasInputDevices base) {
            return base.getMouse();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KeyboardProvider
    extends IndirectProvider<Keyboard, HasInputDevices> {
        @Override
        public Keyboard invoke(HasInputDevices base) {
            return base.getKeyboard();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DatabaseStorageProvider
    extends DirectProvider<DatabaseStorage> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WebStorageProvider
    extends DirectProvider<WebStorage> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BrowserConnectionProvider
    extends DirectProvider<BrowserConnection> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ApplicationCacheProvider
    extends DirectProvider<ApplicationCache> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LocationContextProvider
    extends DirectProvider<LocationContext> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RotatableProvider
    extends DirectProvider<Rotatable> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TakesScreenshotProvider
    extends DirectProvider<TakesScreenshot> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JavascriptExecutorProvider
    extends DirectProvider<JavascriptExecutor> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WebDriverProvider
    extends DirectProvider<WebDriver> {
    }
}

