/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.context;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.jboss.arquillian.graphene.context.BrowserLocal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserActions {
    Map<BrowserLocal, Object> browserLocals = new HashMap<BrowserLocal, Object>();
    private final String name;
    private static ThreadLocal<BrowserActions> currentBrowserActions = new ThreadLocal();
    private static ThreadLocal<BrowserActions> lastBrowserActions = new ThreadLocal();

    public BrowserActions(String name) {
        this.name = name;
    }

    public <T> T performAction(Callable<T> action) throws Exception {
        if (currentBrowserActions.get() != null && currentBrowserActions.get() != this) {
            throw new IllegalStateException("There is an browser interleaving of " + BrowserActions.currentBrowserActions().getName() + " and " + this.getName() + ".");
        }
        currentBrowserActions.set(this);
        lastBrowserActions.set(this);
        try {
            T t = action.call();
            return t;
        }
        finally {
            currentBrowserActions.set(null);
        }
    }

    public static BrowserActions currentBrowserActions() {
        BrowserActions browserActions = currentBrowserActions.get();
        if (browserActions == null) {
            throw new IllegalStateException("There are no active browser actions available.");
        }
        return browserActions;
    }

    public static BrowserActions lastBrowserActions() {
        return lastBrowserActions.get();
    }

    public String getName() {
        return this.name;
    }
}

