/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.spi.javascript;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;

public class JavaScript {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private String source;

    public JavaScript(String source) {
        if (source == null) {
            throw new IllegalArgumentException("The javascript source code can't be null.");
        }
        this.source = source;
    }

    public static JavaScript fromFile(File sourceFile) {
        String sourceCode;
        try {
            sourceCode = JavaScript.inputStreamToString(new FileInputStream(sourceFile));
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("Unable to find JavaScript source file '" + sourceFile + "'", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load JavaScript from file '" + sourceFile + "'", e);
        }
        return JavaScript.fromString(sourceCode);
    }

    public static JavaScript fromResource(String resourceName) {
        String sourceCode;
        InputStream inputStream = JavaScript.class.getResourceAsStream("/" + resourceName);
        if (inputStream == null) {
            throw new IllegalStateException("Can't open the '" + resourceName + "' resource.");
        }
        try {
            sourceCode = JavaScript.inputStreamToString(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load JavaScript from resource with name '" + resourceName + "'", e);
        }
        return JavaScript.fromString(sourceCode);
    }

    public static JavaScript fromString(String source) {
        return new JavaScript(source);
    }

    public JavaScript join(JavaScript javaScriptToJoin) {
        return JavaScript.fromString(this.source + '\n' + javaScriptToJoin.source);
    }

    public JavaScript append(String sourceCodeToAppend) {
        return JavaScript.fromString(this.source + sourceCodeToAppend);
    }

    public String getSourceCode() {
        return this.source;
    }

    public String toString() {
        return this.getSourceCode();
    }

    private static String inputStreamToString(InputStream inputStream) throws IOException {
        StringWriter output = new StringWriter();
        InputStreamReader input = new InputStreamReader(inputStream);
        char[] buffer = new char[4096];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toString();
    }
}

