/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.osgi;

import java.util.ArrayList;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.jboss.arquillian.protocol.jmx.JMXTestRunner;
import org.jboss.arquillian.test.spi.TestResult;
import org.jboss.arquillian.testenricher.osgi.BundleAssociation;
import org.jboss.arquillian.testenricher.osgi.BundleContextAssociation;
import org.jboss.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;
import org.osgi.framework.ServiceReference;

public class ArquillianBundleActivator
implements BundleActivator {
    private static Logger log = Logger.getLogger(ArquillianBundleActivator.class);
    private JMXTestRunner testRunner;

    public void start(final BundleContext context) throws Exception {
        final BundleContext sysContext = context.getBundle(0L).getBundleContext();
        final JMXTestRunner.TestClassLoader testClassLoader = new JMXTestRunner.TestClassLoader(){

            public Class<?> loadTestClass(String className) throws ClassNotFoundException {
                Bundle arqBundle = context.getBundle();
                return arqBundle.loadClass(className);
            }
        };
        MBeanServer mbeanServer = this.getMBeanServer(context);
        this.testRunner = new JMXTestRunner(testClassLoader){

            public TestResult runTestMethodRemote(String className, String methodName) {
                Bundle bundle = null;
                try {
                    Class testClass = testClassLoader.loadTestClass(className);
                    BundleReference bundleRef = (BundleReference)testClass.getClassLoader();
                    bundle = bundleRef.getBundle();
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
                BundleAssociation.setBundle(bundle);
                BundleContextAssociation.setBundleContext((BundleContext)sysContext);
                return super.runTestMethodRemote(className, methodName);
            }
        };
        this.testRunner.registerMBean(mbeanServer);
    }

    public void stop(BundleContext context) throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer(context);
        this.testRunner.unregisterMBean(mbeanServer);
    }

    private MBeanServer getMBeanServer(BundleContext context) {
        ServiceReference sref = context.getServiceReference(MBeanServer.class.getName());
        if (sref != null) {
            MBeanServer mbeanServer = (MBeanServer)context.getService(sref);
            log.debug((Object)("Found MBeanServer fom service: " + mbeanServer.getDefaultDomain()));
            return mbeanServer;
        }
        return this.findOrCreateMBeanServer();
    }

    private MBeanServer findOrCreateMBeanServer() {
        MBeanServer mbeanServer = null;
        ArrayList<MBeanServer> serverArr = MBeanServerFactory.findMBeanServer(null);
        if (serverArr.size() > 1) {
            log.warn((Object)("Multiple MBeanServer instances: " + serverArr));
        }
        if (serverArr.size() > 0) {
            mbeanServer = serverArr.get(0);
            log.debug((Object)("Found MBeanServer: " + mbeanServer.getDefaultDomain()));
        }
        if (mbeanServer == null) {
            log.debug((Object)"No MBeanServer, create one ...");
            mbeanServer = MBeanServerFactory.createMBeanServer();
        }
        return mbeanServer;
    }
}

