/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.jmx;

import java.security.AccessController;
import java.security.PrivilegedAction;

final class SecurityActions {
    private SecurityActions() {
        throw new UnsupportedOperationException("No instantiation");
    }

    static ClassLoader getThreadContextClassLoader() {
        return AccessController.doPrivileged(GetTcclAction.INSTANCE);
    }

    static ClassLoader setThreadContextClassLoader(final ClassLoader classLoader) {
        if (System.getSecurityManager() == null) {
            Thread currentThread = Thread.currentThread();
            ClassLoader current = currentThread.getContextClassLoader();
            currentThread.setContextClassLoader(classLoader);
            return current;
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                Thread currentThread = Thread.currentThread();
                ClassLoader current = currentThread.getContextClassLoader();
                currentThread.setContextClassLoader(classLoader);
                return current;
            }
        });
    }

    static ClassLoader getClassLoader(final Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return clazz.getClassLoader();
            }
        });
    }

    private static enum GetTcclAction implements PrivilegedAction<ClassLoader>
    {
        INSTANCE;


        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

