/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.jmx;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import org.jboss.arquillian.protocol.jmx.JMXTestRunnerMBean;
import org.jboss.arquillian.spi.ContainerMethodExecutor;
import org.jboss.arquillian.spi.TestMethodExecutor;
import org.jboss.arquillian.spi.TestResult;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMXMethodExecutor
implements ContainerMethodExecutor {
    private static Logger log = Logger.getLogger(JMXMethodExecutor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResult invoke(TestMethodExecutor testMethodExecutor) {
        if (testMethodExecutor == null) {
            throw new IllegalArgumentException("TestMethodExecutor null");
        }
        String testClass = testMethodExecutor.getInstance().getClass().getName();
        String testMethod = testMethodExecutor.getMethod().getName();
        TestResult result = null;
        try {
            MBeanServer mbeanServer = this.findOrCreateMBeanServer();
            ObjectName objectName = new ObjectName("jboss.arquillian:service=jmx-test-runner");
            JMXTestRunnerMBean testRunner = this.getMBeanProxy(mbeanServer, objectName, JMXTestRunnerMBean.class);
            InputStream resultStream = testRunner.runTestMethodRemote(testClass, testMethod);
            ObjectInputStream ois = new ObjectInputStream(resultStream);
            result = (TestResult)ois.readObject();
        }
        catch (Throwable e) {
            result = new TestResult(TestResult.Status.FAILED);
            result.setThrowable(e);
        }
        finally {
            result.setEnd(System.currentTimeMillis());
        }
        return result;
    }

    private <T> T getMBeanProxy(MBeanServer mbeanServer, ObjectName name, Class<T> interf) {
        return MBeanServerInvocationHandler.newProxyInstance(mbeanServer, name, interf, false);
    }

    private MBeanServer findOrCreateMBeanServer() {
        MBeanServer mbeanServer = null;
        ArrayList<MBeanServer> serverArr = MBeanServerFactory.findMBeanServer(null);
        if (serverArr.size() > 1) {
            log.warn((Object)("Multiple MBeanServer instances: " + serverArr));
        }
        if (serverArr.size() > 0) {
            mbeanServer = serverArr.get(0);
            log.debug((Object)("Found MBeanServer: " + mbeanServer.getDefaultDomain()));
        }
        if (mbeanServer == null) {
            log.debug((Object)"No MBeanServer, create one ...");
            mbeanServer = MBeanServerFactory.createMBeanServer();
        }
        return mbeanServer;
    }
}

