/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.osgi.internal;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import org.jboss.arquillian.osgi.ArchiveProvider;
import org.jboss.arquillian.osgi.internal.InternalArchiveProvider;
import org.jboss.arquillian.osgi.internal.InternalArchiveProviderImpl;
import org.jboss.arquillian.spi.Configuration;
import org.jboss.arquillian.spi.ContainerMethodExecutor;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.DeployableContainer;
import org.jboss.arquillian.spi.DeploymentException;
import org.jboss.arquillian.spi.LifecycleException;
import org.jboss.arquillian.spi.TestClass;
import org.jboss.arquillian.spi.TestDeployment;
import org.jboss.arquillian.spi.util.ArquillianHelper;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDeployableContainer
implements DeployableContainer {
    private static final Logger log = Logger.getLogger(AbstractDeployableContainer.class);
    private BundleList supportBundles = new BundleList();

    public void setup(Context context, Configuration configuration) {
        log.debug((Object)"Setup OSGi Container");
    }

    public void start(Context context) throws LifecycleException {
        log.debug((Object)"Start OSGi Container");
    }

    public void stop(Context context) throws LifecycleException {
        log.debug((Object)"Stop OSGi Container");
    }

    protected void installSupportBundles() {
        try {
            BundleHandle handle;
            if (!this.isBundleInstalled("osgi.cmpn")) {
                handle = this.installSupportBundle("org.osgi.compendium", false);
                this.supportBundles.add(handle);
            }
            if (!this.isBundleInstalled("arquillian-osgi-bundle")) {
                handle = this.installSupportBundle("arquillian-osgi-bundle", true);
                this.supportBundles.add(handle);
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot install support bundles", ex);
        }
    }

    protected void uninstallSupportBundles() {
        this.uninstallBundleList(this.supportBundles);
    }

    public ContainerMethodExecutor deploy(Context context, Archive<?> archive) throws DeploymentException {
        TestDeployment deployment = (TestDeployment)context.get(TestDeployment.class);
        BundleList bundleList = new BundleList();
        context.add(BundleList.class, (Object)bundleList);
        BundleHandle appHandle = this.installInternal(context, archive);
        bundleList.add(appHandle);
        for (Archive auxArchive : deployment.getAuxiliaryArchives()) {
            BundleHandle auxHandle = this.installInternal(context, auxArchive);
            bundleList.add(auxHandle);
        }
        InternalArchiveProvider archiveProvider = this.processArchiveProvider((TestClass)context.get(TestClass.class));
        if (archiveProvider != null) {
            context.add(InternalArchiveProvider.class, (Object)archiveProvider);
        }
        Properties props = new Properties();
        return this.getMethodExecutor(props);
    }

    public void undeploy(Context context, Archive<?> archive) throws DeploymentException {
        InternalArchiveProvider archiveProvider = (InternalArchiveProvider)context.get(InternalArchiveProvider.class);
        if (archiveProvider != null) {
            archiveProvider.unregisterMBean();
        }
        BundleList bundleList = (BundleList)context.get(BundleList.class);
        this.uninstallBundleList(bundleList);
    }

    private void uninstallBundleList(BundleList bundleList) {
        Collections.reverse(bundleList);
        for (BundleHandle handle : bundleList) {
            if (this.getBundleState(handle) == 1) continue;
            this.uninstallInternal(handle);
        }
        bundleList.clear();
    }

    private BundleHandle installInternal(Context context, Archive<?> archive) throws DeploymentException {
        try {
            log.debug((Object)("Installing bundle: " + archive.getName()));
            return this.installBundle(archive);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new DeploymentException("Cannot install bundle: " + archive.getName(), (Throwable)ex);
        }
    }

    private void uninstallInternal(BundleHandle handle) {
        try {
            log.debug((Object)("Uninstalling bundle: " + handle.getSymbolicName()));
            this.uninstallBundle(handle);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            log.error((Object)("Cannot uninstall bundle: " + handle), (Throwable)ex);
        }
    }

    public abstract ContainerMethodExecutor getMethodExecutor(Properties var1);

    public abstract BundleHandle installBundle(Archive<?> var1) throws BundleException, IOException;

    public abstract BundleHandle installBundle(URL var1) throws BundleException, IOException;

    public abstract void uninstallBundle(BundleHandle var1) throws BundleException, IOException;

    public abstract int getBundleState(BundleHandle var1);

    public abstract void startBundle(BundleHandle var1) throws BundleException;

    public abstract void stopBundle(BundleHandle var1) throws BundleException;

    public abstract boolean isBundleInstalled(String var1);

    private BundleHandle installSupportBundle(String artifactId, boolean startBundle) throws BundleException, IOException {
        URL artifactURL = ArquillianHelper.getArtifactURL(null, (String)artifactId, null);
        if (artifactURL != null) {
            BundleHandle handle = this.installSupportFile(artifactURL, startBundle);
            return handle;
        }
        return null;
    }

    private BundleHandle installSupportFile(URL bundleURL, boolean startBundle) throws BundleException, IOException {
        BundleHandle handle = this.installBundle(bundleURL);
        if (startBundle) {
            this.startBundle(handle);
        }
        return handle;
    }

    private InternalArchiveProvider processArchiveProvider(TestClass testClass) {
        for (Class<?> innerClass : testClass.getJavaClass().getClasses()) {
            if (!ArchiveProvider.class.isAssignableFrom(innerClass)) continue;
            try {
                ArchiveProvider archiveProvider = (ArchiveProvider)innerClass.newInstance();
                InternalArchiveProviderImpl mbean = new InternalArchiveProviderImpl(testClass, archiveProvider);
                mbean.registerMBean();
                return mbean;
            }
            catch (Exception ex) {
                log.error((Object)("Cannot register: " + innerClass.getName()));
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BundleList
    extends ArrayList<BundleHandle> {
        BundleList() {
        }
    }

    public static class BundleHandle {
        private long bundleId;
        private String symbolicName;

        public BundleHandle(long bundleId, String symbolicName) {
            this.bundleId = bundleId;
            this.symbolicName = symbolicName;
        }

        public long getBundleId() {
            return this.bundleId;
        }

        public String getSymbolicName() {
            return this.symbolicName;
        }

        public String toString() {
            return "[" + this.bundleId + "]" + this.symbolicName;
        }
    }
}

