/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.osgi;

import java.util.Collection;
import java.util.jar.Manifest;
import org.jboss.arquillian.container.test.spi.TestDeployment;
import org.jboss.arquillian.container.test.spi.client.deployment.DeploymentPackager;
import org.jboss.arquillian.container.test.spi.client.deployment.ProtocolArchiveProcessor;
import org.jboss.osgi.spi.BundleInfo;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Node;

public class OSGiDeploymentPackager
implements DeploymentPackager {
    public Archive<?> generateDeployment(TestDeployment testDeployment, Collection<ProtocolArchiveProcessor> processors) {
        Archive bundleArchive = testDeployment.getApplicationArchive();
        return this.handleArchive(bundleArchive, testDeployment.getAuxiliaryArchives());
    }

    private Archive<?> handleArchive(Archive<?> archive, Collection<Archive<?>> auxiliaryArchives) {
        try {
            this.validateBundleArchive(archive);
            return archive;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Not a valid OSGi bundle: " + archive, ex);
        }
    }

    private void validateBundleArchive(Archive<?> archive) throws Exception {
        Manifest manifest = null;
        Node node = archive.get("META-INF/MANIFEST.MF");
        if (node != null) {
            manifest = new Manifest(node.getAsset().openStream());
        }
        BundleInfo.validateBundleManifest(manifest);
    }
}

