/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.rest.runner;

import org.jboss.arquillian.container.test.spi.command.Command;
import org.jboss.arquillian.container.test.spi.command.CommandService;
import org.jboss.arquillian.protocol.rest.runner.RESTTestRunner;

public class RESTCommandService
implements CommandService {
    private static long TIMEOUT = 30000L;

    public <T> T execute(Command<T> command) {
        String currentId = RESTTestRunner.currentCall.get();
        RESTTestRunner.events.put(currentId, command);
        long timeoutTime = System.currentTimeMillis() + TIMEOUT;
        while (timeoutTime > System.currentTimeMillis()) {
            Command<?> newCommand = RESTTestRunner.events.get(currentId);
            if (newCommand != null) {
                if (newCommand.getThrowable() != null) {
                    throw new RuntimeException(newCommand.getThrowable());
                }
                if (newCommand.getResult() != null) {
                    return (T)newCommand.getResult();
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("No command response within timeout of " + TIMEOUT + " ms.");
    }
}

