/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.testenricher.cdi.client;

import java.util.Map;
import org.jboss.arquillian.container.test.spi.TestDeployment;
import org.jboss.arquillian.container.test.spi.client.deployment.ProtocolArchiveProcessor;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.GenericArchive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeansXMLProtocolProcessor
implements ProtocolArchiveProcessor {
    public void process(TestDeployment testDeployment, Archive<?> protocolArchive) {
        if (testDeployment.getApplicationArchive() == protocolArchive) {
            return;
        }
        if (this.containsBeansXML(testDeployment.getApplicationArchive())) {
            if (WebArchive.class.isInstance(protocolArchive)) {
                ((WebArchive)WebArchive.class.cast(protocolArchive)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
            } else if (JavaArchive.class.isInstance(protocolArchive)) {
                ((JavaArchive)JavaArchive.class.cast(protocolArchive)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
            }
        }
    }

    private boolean containsBeansXML(Archive<?> archive) {
        Map content = archive.getContent(Filters.include((String)".*/beans\\.xml"));
        if (!content.isEmpty()) {
            return true;
        }
        Map nested = archive.getContent(Filters.include((String)"/.*\\.(jar|war)"));
        if (!nested.isEmpty()) {
            for (ArchivePath path : nested.keySet()) {
                try {
                    if (!this.containsBeansXML(archive.getAsType(GenericArchive.class, path))) continue;
                    return true;
                }
                catch (IllegalArgumentException e) {
                }
            }
        }
        return false;
    }
}

