/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.testenricher.cdi.container;

import java.util.logging.Logger;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.Context;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.testenricher.cdi.container.CDIExtension;

public class BeanManagerProducer {
    private static final String STANDARD_BEAN_MANAGER_JNDI_NAME = "java:comp/BeanManager";
    private static final String SERVLET_BEAN_MANAGER_JNDI_NAME = "java:comp/env/BeanManager";
    private static final String JBOSSAS_BEAN_MANAGER_JNDI_NAME = "BeanManager";
    private static final String[] BEAN_MANAGER_JNDI_NAMES = new String[]{"java:comp/BeanManager", "java:comp/env/BeanManager", "BeanManager"};
    private static final Logger log = Logger.getLogger(BeanManagerProducer.class.getName());
    @Inject
    @ApplicationScoped
    private InstanceProducer<BeanManager> beanManagerProducer;

    public void findBeanManager(@Observes Context context) {
        BeanManager manager = this.lookup(context);
        if (manager != null) {
            this.beanManagerProducer.set((Object)manager);
        }
    }

    private BeanManager lookup(Context context) {
        for (String beanManagerJndiName : BEAN_MANAGER_JNDI_NAMES) {
            try {
                return (BeanManager)context.lookup(beanManagerJndiName);
            }
            catch (Exception e) {
                log.fine("Tried to lookup the BeanManager with name " + beanManagerJndiName + " but caught exception: " + e.getMessage());
            }
        }
        BeanManager beanManager = CDIExtension.getBeanManager();
        if (beanManager != null) {
            return beanManager;
        }
        log.info("BeanManager not found.");
        return null;
    }
}

