/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.testenricher.ejb;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.TestEnricher;
import org.jboss.arquillian.testenricher.ejb.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBInjectionEnricher
implements TestEnricher {
    private static final String ANNOTATION_NAME = "javax.ejb.EJB";
    private static final String ANNOTATION_FIELD_BEAN_INTERFACE = "beanInterface";
    private static final String ANNOTATION_FIELD_MAPPED_NAME = "mappedName";

    public void enrich(Context context, Object testCase) {
        if (SecurityActions.isClassPresent(ANNOTATION_NAME)) {
            this.injectClass(context, testCase);
        }
    }

    public Object[] resolve(Context context, Method method) {
        return new Object[method.getParameterTypes().length];
    }

    protected List<Field> getFieldsWithAnnotation(Class<?> clazz, Class<? extends Annotation> annotation) throws IllegalArgumentException {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz must be specified");
        }
        if (annotation == null) {
            throw new IllegalArgumentException("annotation must be specified");
        }
        return SecurityActions.getFieldsWithAnnotation(clazz, annotation);
    }

    protected void injectClass(Context context, Object testCase) {
        try {
            Class<?> ejbAnnotation = SecurityActions.getThreadContextClassLoader().loadClass(ANNOTATION_NAME);
            List<Field> annotatedFields = SecurityActions.getFieldsWithAnnotation(testCase.getClass(), ejbAnnotation);
            for (Field field : annotatedFields) {
                if (field.get(testCase) != null) continue;
                Object ejb = this.lookupEJB(context, field.getType());
                field.set(testCase, ejb);
            }
            List<Method> methods = SecurityActions.getMethodsWithAnnotation(testCase.getClass(), ejbAnnotation);
            for (Method method : methods) {
                if (method.getParameterTypes().length != 1) {
                    throw new RuntimeException("@EJB only allowed on single argument methods");
                }
                if (!method.getName().startsWith("set")) {
                    throw new RuntimeException("@EJB only allowed on 'set' methods");
                }
                Object ejb = this.lookupEJB(context, method.getParameterTypes()[0]);
                method.invoke(testCase, ejb);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not inject members", e);
        }
    }

    protected Object lookupEJB(Context context, Class<?> fieldType) throws Exception {
        String[] jndiNames;
        InitialContext initcontext = this.createContext(context);
        for (String jndiName : jndiNames = new String[]{"java:global/test.ear/test/" + fieldType.getSimpleName() + "Bean", "java:global/test.ear/test/" + fieldType.getSimpleName(), "java:global/test/" + fieldType.getSimpleName(), "java:global/test/" + fieldType.getSimpleName() + "Bean", "java:global/test/" + fieldType.getSimpleName() + "/no-interface", "test/" + fieldType.getSimpleName() + "Bean/local", "test/" + fieldType.getSimpleName() + "Bean/remote", "test/" + fieldType.getSimpleName() + "/no-interface", fieldType.getSimpleName() + "Bean/local", fieldType.getSimpleName() + "Bean/remote", fieldType.getSimpleName() + "/no-interface"}) {
            try {
                return initcontext.lookup(jndiName);
            }
            catch (NamingException e) {
            }
        }
        throw new NamingException("No EJB found in JNDI, tried the following names: " + this.joinJndiNames(jndiNames));
    }

    protected InitialContext createContext(Context context) throws Exception {
        return new InitialContext();
    }

    private String joinJndiNames(String[] strings) {
        StringBuilder sb = new StringBuilder();
        for (String string : strings) {
            sb.append(string).append(", ");
        }
        return sb.toString();
    }
}

