/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.testenricher.ejb;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

final class SecurityActions {
    private SecurityActions() {
        throw new UnsupportedOperationException("No instantiation");
    }

    static ClassLoader getThreadContextClassLoader() {
        return AccessController.doPrivileged(GetTcclAction.INSTANCE);
    }

    static boolean isClassPresent(String name) {
        try {
            SecurityActions.loadClass(name);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    static Class<?> loadClass(String className) {
        try {
            return Class.forName(className, true, SecurityActions.getThreadContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName(className, true, SecurityActions.class.getClassLoader());
            }
            catch (ClassNotFoundException e2) {
                throw new RuntimeException("Could not load class " + className, e2);
            }
        }
    }

    static <T> T newInstance(String className, Class<?>[] argumentTypes, Object[] arguments, Class<T> expectedType) {
        Class<?> implClass = SecurityActions.loadClass(className);
        if (!expectedType.isAssignableFrom(implClass)) {
            throw new RuntimeException("Loaded class " + className + " is not of expected type " + expectedType);
        }
        return (T)SecurityActions.newInstance(implClass, argumentTypes, arguments);
    }

    static <T> T newInstance(String className, Class<?>[] argumentTypes, Object[] arguments, Class<T> expectedType, ClassLoader classLoader) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className, false, classLoader);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load class " + className, e);
        }
        Object obj = SecurityActions.newInstance(clazz, argumentTypes, arguments);
        try {
            return expectedType.cast(obj);
        }
        catch (Exception e) {
            throw new RuntimeException("Loaded class " + className + " is not of expected type " + expectedType, e);
        }
    }

    static <T> T newInstance(Class<T> implClass, Class<?>[] argumentTypes, Object[] arguments) {
        T obj;
        if (implClass == null) {
            throw new IllegalArgumentException("ImplClass must be specified");
        }
        if (argumentTypes == null) {
            throw new IllegalArgumentException("ArgumentTypes must be specified. Use empty array if no arguments");
        }
        if (arguments == null) {
            throw new IllegalArgumentException("Arguments must be specified. Use empty array if no arguments");
        }
        try {
            Constructor<T> constructor = SecurityActions.getConstructor(implClass, argumentTypes);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            obj = constructor.newInstance(arguments);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create new instance of " + implClass, e);
        }
        return obj;
    }

    static <T> Constructor<T> getConstructor(final Class<T> clazz, final Class<?> ... argumentTypes) throws NoSuchMethodException {
        try {
            return (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction<Constructor<T>>(){

                @Override
                public Constructor<T> run() throws NoSuchMethodException {
                    return clazz.getDeclaredConstructor(argumentTypes);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable t = pae.getCause();
            if (t instanceof NoSuchMethodException) {
                throw (NoSuchMethodException)t;
            }
            try {
                throw (RuntimeException)t;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t);
            }
        }
    }

    public static void setFieldValue(final Class<?> source, final Object target, final String fieldName, final Object value) throws NoSuchFieldException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    Field field = source.getDeclaredField(fieldName);
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    field.set(target, value);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable t = pae.getCause();
            if (t instanceof NoSuchFieldException) {
                throw (NoSuchFieldException)t;
            }
            try {
                throw (RuntimeException)t;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t);
            }
        }
    }

    public static List<Field> getFieldsWithAnnotation(final Class<?> source, final Class<? extends Annotation> annotationClass) {
        List<Field> declaredAccessableFields = AccessController.doPrivileged(new PrivilegedAction<List<Field>>(){

            @Override
            public List<Field> run() {
                ArrayList<Field> foundFields = new ArrayList<Field>();
                for (Class nextSource = source; nextSource != Object.class; nextSource = nextSource.getSuperclass()) {
                    for (Field field : nextSource.getDeclaredFields()) {
                        if (!field.isAnnotationPresent(annotationClass)) continue;
                        if (!field.isAccessible()) {
                            field.setAccessible(true);
                        }
                        foundFields.add(field);
                    }
                }
                return foundFields;
            }
        });
        return declaredAccessableFields;
    }

    public static List<Method> getMethodsWithAnnotation(final Class<?> source, final Class<? extends Annotation> annotationClass) {
        List<Method> declaredAccessableMethods = AccessController.doPrivileged(new PrivilegedAction<List<Method>>(){

            @Override
            public List<Method> run() {
                ArrayList<Method> foundMethods = new ArrayList<Method>();
                for (Class nextSource = source; nextSource != Object.class; nextSource = nextSource.getSuperclass()) {
                    for (Method method : SecurityActions.filterBridgeMethods(nextSource.getDeclaredMethods())) {
                        if (!method.isAnnotationPresent(annotationClass)) continue;
                        if (!method.isAccessible()) {
                            method.setAccessible(true);
                        }
                        foundMethods.add(method);
                    }
                }
                return foundMethods;
            }
        });
        return declaredAccessableMethods;
    }

    static String getProperty(final String key) {
        try {
            String value = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(key);
                }
            });
            return value;
        }
        catch (PrivilegedActionException pae) {
            Throwable t = pae.getCause();
            if (t instanceof SecurityException) {
                throw (SecurityException)t;
            }
            if (t instanceof NullPointerException) {
                throw (NullPointerException)t;
            }
            if (t instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t;
            }
            try {
                throw (RuntimeException)t;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t);
            }
        }
    }

    private static Collection<Method> filterBridgeMethods(Method ... declaredMethods) {
        ArrayList<Method> nonBridgeMethods = new ArrayList<Method>(declaredMethods.length);
        for (Method declaredMethod : declaredMethods) {
            if (declaredMethod.isBridge()) continue;
            nonBridgeMethods.add(declaredMethod);
        }
        return nonBridgeMethods;
    }

    private static enum GetTcclAction implements PrivilegedAction<ClassLoader>
    {
        INSTANCE;


        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

