/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.testenricher.osgi;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.inject.Inject;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import org.jboss.arquillian.osgi.OSGiContainer;
import org.jboss.arquillian.osgi.internal.EmbeddedOSGiContainer;
import org.jboss.arquillian.osgi.internal.RemoteOSGiContainer;
import org.jboss.arquillian.protocol.jmx.JMXMethodExecutor;
import org.jboss.arquillian.protocol.jmx.JMXServerFactory;
import org.jboss.arquillian.protocol.jmx.JMXTestRunner;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.TestClass;
import org.jboss.arquillian.spi.TestEnricher;
import org.jboss.arquillian.testenricher.osgi.BundleContextHolder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiTestEnricher
implements TestEnricher {
    public void enrich(Context context, Object testCase) {
        Class<?> testClass = testCase.getClass();
        for (Field field : testClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Inject.class)) continue;
            if (field.getType().isAssignableFrom(OSGiContainer.class)) {
                this.injectContainer(context, testCase, field);
                continue;
            }
            if (field.getType().isAssignableFrom(BundleContext.class)) {
                this.injectBundleContext(context, testCase, field);
                continue;
            }
            if (!field.getType().isAssignableFrom(Bundle.class)) continue;
            this.injectBundle(context, testCase, field);
        }
    }

    public Object[] resolve(Context context, Method method) {
        return null;
    }

    private void injectContainer(Context context, Object testCase, Field field) {
        try {
            TestClass testClass = new TestClass(testCase.getClass());
            field.set(testCase, this.getContainer(context, testClass));
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Cannot inject BundleContext", ex);
        }
    }

    private void injectBundleContext(Context context, Object testCase, Field field) {
        try {
            field.set(testCase, this.getBundleContext(context));
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Cannot inject BundleContext", ex);
        }
    }

    private void injectBundle(Context context, Object testCase, Field field) {
        try {
            field.set(testCase, this.getTestBundle(context, testCase.getClass()));
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Cannot inject Bundle", ex);
        }
    }

    private OSGiContainer getContainer(Context context, TestClass testClass) {
        BundleContext bundleContext = this.getBundleContext(context);
        if (JMXTestRunner.getExecutionType() == JMXMethodExecutor.ExecutionType.REMOTE) {
            return new RemoteOSGiContainer(bundleContext, testClass);
        }
        return new EmbeddedOSGiContainer(bundleContext, testClass);
    }

    private BundleContext getBundleContext(Context context) {
        BundleContext bundleContext = (BundleContext)context.get(BundleContext.class);
        if (bundleContext == null) {
            bundleContext = this.getBundleContextFromHolder();
        }
        bundleContext = bundleContext.getBundle(0L).getBundleContext();
        return bundleContext;
    }

    private Bundle getTestBundle(Context context, Class<?> testClass) {
        Bundle testBundle = (Bundle)context.get(Bundle.class);
        if (testBundle == null) {
            BundleContext bundleContext = this.getBundleContext(context);
            ServiceReference sref = bundleContext.getServiceReference(PackageAdmin.class.getName());
            PackageAdmin pa = (PackageAdmin)bundleContext.getService(sref);
            testBundle = pa.getBundle(testClass);
        }
        return testBundle;
    }

    private BundleContext getBundleContextFromHolder() {
        try {
            MBeanServer mbeanServer = JMXServerFactory.findOrCreateMBeanServer();
            ObjectName oname = new ObjectName("jboss.arquillian:service=bundle-context");
            if (!mbeanServer.isRegistered(oname)) {
                throw new IllegalStateException("BundleContextHolder not registered");
            }
            BundleContextHolder holder = MBeanServerInvocationHandler.newProxyInstance(mbeanServer, oname, BundleContextHolder.class, false);
            return holder.getBundleContext();
        }
        catch (JMException ex) {
            throw new IllegalStateException("Cannot obtain system context", ex);
        }
    }
}

