/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.testenricher.osgi;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import org.jboss.arquillian.osgi.OSGiContainer;
import org.jboss.arquillian.osgi.internal.EmbeddedOSGiContainer;
import org.jboss.arquillian.osgi.internal.RemoteOSGiContainer;
import org.jboss.arquillian.protocol.jmx.ExecutionTypeAssociation;
import org.jboss.arquillian.protocol.jmx.ExecutionTypeInjector;
import org.jboss.arquillian.protocol.jmx.JMXMethodExecutor;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.Logger;
import org.jboss.arquillian.spi.TestClass;
import org.jboss.arquillian.spi.TestEnricher;
import org.jboss.arquillian.testenricher.osgi.BundleContextHolder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class OSGiTestEnricher
implements TestEnricher,
ExecutionTypeInjector {
    private static Logger log = Logger.getLogger(OSGiTestEnricher.class);
    private JMXMethodExecutor.ExecutionType executionType;

    public void inject(JMXMethodExecutor.ExecutionType value) {
        this.executionType = value;
    }

    public void enrich(Context context, Object testCase) {
        this.inject(ExecutionTypeAssociation.getExecutionType());
        Class<?> testClass = testCase.getClass();
        for (Field field : testClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Inject.class)) continue;
            if (field.getType().isAssignableFrom(OSGiContainer.class)) {
                this.injectOSGiContainer(context, testCase, field);
            } else if (field.getType().isAssignableFrom(BundleContext.class)) {
                this.injectBundleContext(context, testCase, field);
            }
            if (!field.getType().isAssignableFrom(Bundle.class)) continue;
            this.injectBundle(context, testCase, field);
        }
    }

    public Object[] resolve(Context context, Method method) {
        return null;
    }

    private void injectOSGiContainer(Context context, Object testCase, Field field) {
        try {
            TestClass testClass = new TestClass(testCase.getClass());
            field.set(testCase, this.getOSGiContainer(context, testClass));
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Cannot inject BundleContext", ex);
        }
    }

    private void injectBundleContext(Context context, Object testCase, Field field) {
        try {
            field.set(testCase, this.getBundleContext(context));
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Cannot inject BundleContext", ex);
        }
    }

    private void injectBundle(Context context, Object testCase, Field field) {
        try {
            field.set(testCase, this.getTestBundle(context, testCase.getClass()));
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Cannot inject Bundle", ex);
        }
    }

    private OSGiContainer getOSGiContainer(Context context, TestClass testClass) {
        BundleContext bundleContext = this.getBundleContext(context);
        EmbeddedOSGiContainer result = null;
        if (this.executionType == JMXMethodExecutor.ExecutionType.EMBEDDED) {
            result = new EmbeddedOSGiContainer(bundleContext, testClass);
        } else if (this.executionType == JMXMethodExecutor.ExecutionType.REMOTE) {
            result = new RemoteOSGiContainer(bundleContext, testClass);
        }
        return result;
    }

    private BundleContext getBundleContext(Context context) {
        BundleContext bundleContext = (BundleContext)context.get(BundleContext.class);
        if (bundleContext == null) {
            bundleContext = this.getBundleContextFromHolder();
        }
        bundleContext = bundleContext.getBundle(0L).getBundleContext();
        return bundleContext;
    }

    private Bundle getTestBundle(Context context, Class<?> testClass) {
        Bundle testbundle = (Bundle)context.get(Bundle.class);
        if (testbundle == null) {
            BundleContext bundleContext = this.getBundleContext(context);
            ServiceReference sref = bundleContext.getServiceReference(PackageAdmin.class.getName());
            PackageAdmin pa = (PackageAdmin)bundleContext.getService(sref);
            testbundle = pa.getBundle(testClass);
        }
        return testbundle;
    }

    private BundleContext getBundleContextFromHolder() {
        try {
            MBeanServer mbeanServer = OSGiTestEnricher.findOrCreateMBeanServer();
            ObjectName oname = new ObjectName("jboss.arquillian:service=bundle-context");
            BundleContextHolder holder = MBeanServerInvocationHandler.newProxyInstance(mbeanServer, oname, BundleContextHolder.class, false);
            return holder.getBundleContext();
        }
        catch (JMException ex) {
            throw new IllegalStateException("Cannot obtain arquillian-bundle context", ex);
        }
    }

    public static MBeanServer findOrCreateMBeanServer() {
        MBeanServer mbeanServer = null;
        ArrayList<MBeanServer> serverArr = MBeanServerFactory.findMBeanServer(null);
        if (serverArr.size() > 1) {
            log.warning("Multiple MBeanServer instances: " + serverArr);
        }
        if (serverArr.size() > 0) {
            mbeanServer = serverArr.get(0);
            log.fine("Found MBeanServer: " + mbeanServer.getDefaultDomain());
        }
        if (mbeanServer == null) {
            log.fine("No MBeanServer, create one ...");
            mbeanServer = MBeanServerFactory.createMBeanServer();
        }
        return mbeanServer;
    }
}

