/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.testenricher.osgi;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.inject.Inject;
import org.jboss.arquillian.osgi.OSGiContainer;
import org.jboss.arquillian.protocol.jmx.ResourceCallbackHandler;
import org.jboss.arquillian.protocol.jmx.ResourceCallbackHandlerAssociation;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.TestClass;
import org.jboss.arquillian.spi.TestEnricher;
import org.jboss.arquillian.testenricher.osgi.BundleAssociation;
import org.jboss.arquillian.testenricher.osgi.BundleContextAssociation;
import org.jboss.arquillian.testenricher.osgi.BundleContextInjector;
import org.jboss.arquillian.testenricher.osgi.BundleInjector;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class OSGiTestEnricher
implements TestEnricher,
BundleContextInjector,
BundleInjector {
    private BundleContext bundleContext;
    private Bundle bundle;

    @Override
    public void inject(Bundle value) {
        this.bundle = value;
    }

    @Override
    public void inject(BundleContext value) {
        this.bundleContext = value;
    }

    public void enrich(Context context, Object testCase) {
        this.inject(BundleContextAssociation.getBundleContext());
        this.inject(BundleAssociation.getBundle());
        Class<?> testClass = testCase.getClass();
        if (this.bundle == null || !OSGiTestEnricher.isInjectionTarget(testClass)) {
            return;
        }
        for (Field field : testClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Inject.class)) continue;
            if (field.getType().isAssignableFrom(OSGiContainer.class)) {
                this.injectOSGiContainer(context, testCase, field);
            } else if (field.getType().isAssignableFrom(BundleContext.class)) {
                this.injectBundleContext(context, testCase, field);
            }
            if (!field.getType().isAssignableFrom(Bundle.class)) continue;
            this.injectBundle(context, testCase, field);
        }
    }

    public Object[] resolve(Context context, Method method) {
        return null;
    }

    public static boolean isInjectionTarget(Class<?> testClass) {
        for (Field field : testClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Inject.class)) continue;
            if (field.getType().isAssignableFrom(OSGiContainer.class)) {
                return true;
            }
            if (field.getType().isAssignableFrom(BundleContext.class)) {
                return true;
            }
            if (!field.getType().isAssignableFrom(Bundle.class)) continue;
            return true;
        }
        return false;
    }

    private void injectOSGiContainer(Context context, Object testCase, Field field) {
        try {
            TestClass testClass = new TestClass(testCase.getClass());
            field.set(testCase, this.getOSGiContainer(context, testClass));
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Cannot inject BundleContext", ex);
        }
    }

    private void injectBundleContext(Context context, Object testCase, Field field) {
        try {
            field.set(testCase, this.bundleContext);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Cannot inject BundleContext", ex);
        }
    }

    private void injectBundle(Context context, Object testCase, Field field) {
        try {
            field.set(testCase, this.bundle);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Cannot inject Bundle", ex);
        }
    }

    private OSGiContainer getOSGiContainer(Context context, TestClass testClass) {
        ResourceCallbackHandler callbackHandler = ResourceCallbackHandlerAssociation.getCallbackHandler();
        return OSGiContainer.Factory.newInstance((BundleContext)this.bundleContext, (TestClass)testClass, (ResourceCallbackHandler)callbackHandler);
    }
}

