/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.testenricher.osgi;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import org.jboss.arquillian.spi.TestEnricher;
import org.jboss.arquillian.spi.core.Instance;
import org.jboss.arquillian.testenricher.osgi.BundleContextHolder;
import org.jboss.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiTestEnricher
implements TestEnricher {
    private static Logger log = Logger.getLogger(OSGiTestEnricher.class);
    @org.jboss.arquillian.spi.core.annotation.Inject
    private Instance<BundleContext> bundleContextInst;
    @org.jboss.arquillian.spi.core.annotation.Inject
    private Instance<Bundle> bundleInst;

    public void enrich(Object testCase) {
        Class<?> testClass = testCase.getClass();
        for (Field field : testClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Inject.class)) continue;
            if (field.getType().isAssignableFrom(BundleContext.class)) {
                this.injectBundleContext(testCase, field);
            }
            if (!field.getType().isAssignableFrom(Bundle.class)) continue;
            this.injectBundle(testCase, field);
        }
    }

    public Object[] resolve(Method method) {
        return null;
    }

    private void injectBundleContext(Object testCase, Field field) {
        try {
            field.set(testCase, this.getSystemBundleContext());
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Cannot inject BundleContext", ex);
        }
    }

    private void injectBundle(Object testCase, Field field) {
        try {
            field.set(testCase, this.getTestBundle(testCase.getClass()));
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Cannot inject Bundle", ex);
        }
    }

    private BundleContext getSystemBundleContext() {
        BundleContext bundleContext = (BundleContext)this.bundleContextInst.get();
        if (bundleContext == null) {
            bundleContext = this.getBundleContextFromHolder();
        }
        bundleContext = bundleContext.getBundle(0L).getBundleContext();
        return bundleContext;
    }

    private Bundle getTestBundle(Class<?> testClass) {
        Bundle testbundle = (Bundle)this.bundleInst.get();
        if (testbundle == null) {
            BundleContext bundleContext = this.getSystemBundleContext();
            ServiceReference sref = bundleContext.getServiceReference(PackageAdmin.class.getName());
            PackageAdmin pa = (PackageAdmin)bundleContext.getService(sref);
            testbundle = pa.getBundle(testClass);
        }
        return testbundle;
    }

    private BundleContext getBundleContextFromHolder() {
        try {
            MBeanServer mbeanServer = OSGiTestEnricher.findOrCreateMBeanServer();
            ObjectName oname = new ObjectName("jboss.arquillian:service=bundle-context");
            BundleContextHolder holder = MBeanServerInvocationHandler.newProxyInstance(mbeanServer, oname, BundleContextHolder.class, false);
            return holder.getBundleContext();
        }
        catch (JMException ex) {
            throw new IllegalStateException("Cannot obtain arquillian-bundle context", ex);
        }
    }

    public static MBeanServer findOrCreateMBeanServer() {
        MBeanServer mbeanServer = null;
        ArrayList<MBeanServer> serverArr = MBeanServerFactory.findMBeanServer(null);
        if (serverArr.size() > 1) {
            log.warn((Object)("Multiple MBeanServer instances: " + serverArr));
        }
        if (serverArr.size() > 0) {
            mbeanServer = serverArr.get(0);
            log.debug((Object)("Found MBeanServer: " + mbeanServer.getDefaultDomain()));
        }
        if (mbeanServer == null) {
            log.debug((Object)"No MBeanServer, create one ...");
            mbeanServer = MBeanServerFactory.createMBeanServer();
        }
        return mbeanServer;
    }
}

