/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.testenricher.osgi;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.osgi.StartLevelAware;
import org.jboss.arquillian.test.spi.TestEnricher;
import org.jboss.arquillian.testenricher.osgi.BundleAssociation;
import org.jboss.arquillian.testenricher.osgi.BundleContextAssociation;
import org.jboss.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;

public class OSGiTestEnricher
implements TestEnricher {
    private static final Logger log = Logger.getLogger(OSGiTestEnricher.class);

    public void enrich(Object testCase) {
        BundleContext bundleContext = this.getBundleContext();
        if (bundleContext == null) {
            log.debugf("System bundle context not available", new Object[0]);
            return;
        }
        Class<?> testClass = testCase.getClass();
        for (Field field : testClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Inject.class)) continue;
            if (field.getType().isAssignableFrom(BundleContext.class)) {
                this.injectBundleContext(testCase, field);
                continue;
            }
            if (field.getType().isAssignableFrom(Bundle.class)) {
                this.injectBundle(testCase, field);
                continue;
            }
            if (field.getType().isAssignableFrom(PackageAdmin.class)) {
                this.injectPackageAdmin(testCase, field);
                continue;
            }
            if (!field.getType().isAssignableFrom(StartLevel.class)) continue;
            this.injectStartLevel(testCase, field);
        }
        for (AccessibleObject accessibleObject : testClass.getDeclaredMethods()) {
            Deployment andep;
            if (!accessibleObject.isAnnotationPresent(Deployment.class) || !(andep = ((Method)accessibleObject).getAnnotation(Deployment.class)).managed() || !andep.testable() || !accessibleObject.isAnnotationPresent(StartLevelAware.class)) continue;
            int bundleStartLevel = ((Method)accessibleObject).getAnnotation(StartLevelAware.class).startLevel();
            StartLevel startLevel = this.getStartLevel();
            Bundle bundle = this.getBundle(testCase);
            log.debugf("Setting bundle start level of %s to: %d", (Object)bundle, (Object)bundleStartLevel);
            startLevel.setBundleStartLevel(bundle, bundleStartLevel);
        }
    }

    public Object[] resolve(Method method) {
        return null;
    }

    private void injectBundleContext(Object testCase, Field field) {
        try {
            BundleContext context = this.getBundleContext();
            log.debugf("Injecting bundle context: %s", (Object)context);
            field.set(testCase, context);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Cannot inject BundleContext", ex);
        }
    }

    private void injectBundle(Object testCase, Field field) {
        try {
            Bundle bundle = this.getBundle(testCase);
            log.debugf("Injecting bundle: %s", (Object)bundle);
            field.set(testCase, bundle);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Cannot inject Bundle", ex);
        }
    }

    private void injectPackageAdmin(Object testCase, Field field) {
        try {
            PackageAdmin packageAdmin = this.getPackageAdmin();
            log.debugf("Injecting PackageAdmin: %s", (Object)packageAdmin);
            field.set(testCase, packageAdmin);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Cannot inject PackageAdmin", ex);
        }
    }

    private void injectStartLevel(Object testCase, Field field) {
        try {
            StartLevel startLevel = this.getStartLevel();
            log.debugf("Injecting StartLevel: %s", (Object)startLevel);
            field.set(testCase, startLevel);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Cannot inject StartLevel", ex);
        }
    }

    private PackageAdmin getPackageAdmin() {
        BundleContext context = this.getBundleContext();
        ServiceReference sref = context.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin = (PackageAdmin)context.getService(sref);
        return packageAdmin;
    }

    private StartLevel getStartLevel() {
        BundleContext context = this.getBundleContext();
        ServiceReference sref = context.getServiceReference(StartLevel.class.getName());
        StartLevel startLevel = (StartLevel)context.getService(sref);
        return startLevel;
    }

    private Bundle getBundle(Object testCase) {
        ClassLoader classLoader;
        Bundle bundle = BundleAssociation.getBundle();
        if (bundle == null && (classLoader = testCase.getClass().getClassLoader()) instanceof BundleReference) {
            BundleReference bref = (BundleReference)classLoader;
            bundle = bref.getBundle();
        }
        return bundle;
    }

    private BundleContext getBundleContext() {
        ClassLoader classLoader;
        BundleContext bundleContext = BundleContextAssociation.getBundleContext();
        if (bundleContext == null && (classLoader = OSGiTestEnricher.class.getClassLoader()) instanceof BundleReference) {
            BundleReference bref = (BundleReference)classLoader;
            bundleContext = bref.getBundle().getBundleContext();
            bundleContext = bundleContext.getBundle(0L).getBundleContext();
        }
        return bundleContext;
    }
}

