/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.console.spi;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;
import org.jboss.as.console.spi.ExtensionDeclaration;
import org.jboss.as.console.spi.GinExtensionBinding;
import org.jboss.as.console.spi.TemplateProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class ExtensionBindingProcessor
extends AbstractProcessor {
    private static final String TEMPLATE = "ExtensionBinding.tmpl";
    private static final String FILENAME = "org.jboss.as.console.client.core.gin.CompositeBinding";
    private Filer filer;
    private Messager messager;
    private ProcessingEnvironment processingEnv;
    List<ExtensionDeclaration> discovered;

    @Override
    public void init(ProcessingEnvironment env) {
        this.processingEnv = env;
        this.filer = env.getFiler();
        this.messager = env.getMessager();
        this.discovered = new ArrayList<ExtensionDeclaration>();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> types = new HashSet<String>();
        types.add(GinExtensionBinding.class.getName());
        return types;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            System.out.println("Begin Module discovery ...");
            Set<? extends Element> elements = roundEnv.getRootElements();
            for (Element element : elements) {
                this.handleRootElementAnnotationMirrors(element, this.discovered);
            }
        }
        if (roundEnv.processingOver()) {
            try {
                this.writeModuleFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println("Module discovery completed.");
        }
        return true;
    }

    private void handleRootElementAnnotationMirrors(Element aElement, List<ExtensionDeclaration> discovered) {
        List<? extends AnnotationMirror> annotationMirrors = aElement.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            String annotationType = annotationMirror.getAnnotationType().toString();
            if (!annotationType.equals(GinExtensionBinding.class.getName())) continue;
            discovered.add(new ExtensionDeclaration(((Object)aElement.asType()).toString()));
        }
    }

    private void writeModuleFile() throws Exception {
        JavaFileObject sourceFile = this.filer.createSourceFile(FILENAME, new Element[0]);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("extensions", this.discovered);
        OutputStream output = sourceFile.openOutputStream();
        new TemplateProcessor().process(TEMPLATE, model, output);
        output.flush();
        output.close();
    }
}

