/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.console.client.plugins;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ResourceMapping {
    private Map<String, Set<String>> token2address = new HashMap<String, Set<String>>();
    private Map<String, MetaData> mappings = new HashMap<String, MetaData>();

    public void put(String token, String address, String facet, String recursive) {
        if (null == this.token2address.get(token)) {
            this.token2address.put(token, new HashSet());
        }
        this.token2address.get(token).add(address);
        this.mappings.put(token, new MetaData(token, address, facet, Boolean.valueOf(recursive)));
    }

    public Set<String> getResources(String token) {
        if (null == this.token2address.get(token)) {
            this.token2address.put(token, new HashSet());
        }
        return this.token2address.get(token);
    }

    public String getFacet(String token) {
        return this.mappings.get(token) != null ? this.mappings.get((Object)token).facet : "configuration";
    }

    public boolean isRecursive(String token) {
        return this.mappings.get(token) == null || this.mappings.get((Object)token).recursive;
    }

    class MetaData {
        String token;
        String address;
        String facet;
        boolean recursive;

        MetaData(String token, String address, String facet, boolean recursive) {
            this.token = token;
            this.address = address;
            this.facet = facet;
            this.recursive = recursive;
        }
    }
}

