/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.console.client.plugins;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ResourceMapping {
    private Map<String, Set<String>> token2address = new HashMap<String, Set<String>>();
    private Map<String, MetaData> mappings = new HashMap<String, MetaData>();
    private Map<String, Set<String>> operations = new HashMap<String, Set<String>>();

    public void put(String token, String address, String recursive) {
        if (null == this.token2address.get(token)) {
            this.token2address.put(token, new HashSet());
        }
        this.token2address.get(token).add(address);
        this.mappings.put(token, new MetaData(token, address, Boolean.valueOf(recursive)));
    }

    public void addOperation(String token, String opString) {
        if (null == this.operations.get(token)) {
            this.operations.put(token, new HashSet());
        }
        this.operations.get(token).add(opString);
    }

    public Set<String> getOperations(String token) {
        return this.operations.get(token) != null ? this.operations.get(token) : Collections.EMPTY_SET;
    }

    public Set<String> getResources(String token) {
        if (null == this.token2address.get(token)) {
            this.token2address.put(token, new HashSet());
        }
        return this.token2address.get(token);
    }

    public boolean isRecursive(String token) {
        return this.mappings.get(token) == null || this.mappings.get((Object)token).recursive;
    }

    class MetaData {
        String token;
        String address;
        boolean recursive;

        MetaData(String token, String address, boolean recursive) {
            this.token = token;
            this.address = address;
            this.recursive = recursive;
        }
    }
}

