/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.console.spi;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.jboss.as.console.spi.TemplateProcessor;

public class ModuleConfig {
    static final String MODULE_PACKAGE = "org.jboss.as.console.composite";
    private final Filer filer;
    private final String template;
    private final String filename;

    public ModuleConfig(Filer filer, String template, String filename) {
        this.filer = filer;
        this.template = template;
        this.filename = filename;
    }

    public void writeModuleFile(Set<String> inheritFrom, Map<String, String> properties) {
        try {
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("modules", inheritFrom);
            model.put("properties", properties);
            FileObject sourceFile = this.filer.createResource(StandardLocation.SOURCE_OUTPUT, MODULE_PACKAGE, this.filename, new Element[0]);
            OutputStream output = sourceFile.openOutputStream();
            new TemplateProcessor().process(this.template, model, output);
            output.flush();
            output.close();
            System.out.println("Written GWT module to " + sourceFile.toUri().toString());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create file", e);
        }
    }
}

