/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.processors;

import com.google.auto.common.AnnotationMirrors;
import com.google.auto.common.MoreElements;
import com.google.auto.service.AutoService;
import com.google.web.bindery.autobean.shared.AutoBeanFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.jboss.as.console.spi.BeanFactoryExtension;
import org.jboss.hal.processors.AbstractHalProcessor;

@SupportedAnnotationTypes(value={"org.jboss.as.console.spi.BeanFactoryExtension", "com.google.web.bindery.autobean.shared.AutoBeanFactory.Category"})
@AutoService(value=Processor.class)
public class BeanFactoryProcessor
extends AbstractHalProcessor {
    static final String BEAN_FACTORY_TEMPLATE = "BeanFactory.ftl";
    static final String BEAN_FACTORY_PACKAGE = "org.jboss.as.console.client.shared";
    static final String BEAN_FACTORY_CLASS = "BeanFactory";
    private final Set<String> factories = new HashSet<String>();
    private final Set<String> categories = new HashSet<String>();

    @Override
    protected boolean onProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(BeanFactoryExtension.class)) {
            TypeElement factoryElement = (TypeElement)element;
            this.factories.add(factoryElement.getQualifiedName().toString());
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(AutoBeanFactory.Category.class)) {
            AnnotationMirror categoryAnnotation = (AnnotationMirror)MoreElements.getAnnotationMirror((Element)element, AutoBeanFactory.Category.class).get();
            AnnotationValue value = AnnotationMirrors.getAnnotationValue((AnnotationMirror)categoryAnnotation, (String)"value");
            Collection<String> categories = this.extractValue(value);
            this.categories.addAll(categories);
        }
        if (!this.factories.isEmpty()) {
            this.debug("Generating composite bean factory", new Object[0]);
            this.code(BEAN_FACTORY_TEMPLATE, BEAN_FACTORY_PACKAGE, BEAN_FACTORY_CLASS, () -> {
                HashMap<String, Object> context = new HashMap<String, Object>();
                context.put("packageName", BEAN_FACTORY_PACKAGE);
                context.put("className", BEAN_FACTORY_CLASS);
                context.put("factories", this.factories);
                context.put("categories", this.categories);
                return context;
            });
            this.info("Successfully generated composite bean factory [%s].", BEAN_FACTORY_CLASS);
            this.factories.clear();
            this.categories.clear();
        }
        return false;
    }

    private Collection<String> extractValue(AnnotationValue value) {
        if (value.getValue() instanceof Collection) {
            List varray = (List)value.getValue();
            ArrayList<String> result = new ArrayList<String>(varray.size());
            for (Object active : varray) {
                result.addAll(this.extractValue((AnnotationValue)active));
            }
            return result;
        }
        return Collections.singleton(value.getValue().toString());
    }
}

