/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.processors;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.Version;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.jboss.hal.processors.GenerationException;

public abstract class AbstractHalProcessor
extends AbstractProcessor {
    protected final Configuration config;
    private int round;
    protected Types typeUtils;
    protected Elements elementUtils;
    protected Filer filer;
    protected Messager messager;

    public AbstractHalProcessor() {
        Version version = new Version(2, 3, 22);
        this.config = new Configuration(version);
        this.config.setDefaultEncoding("UTF-8");
        this.config.setClassForTemplateLoading(this.getClass(), "templates");
        this.config.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapperBuilder(version).build());
    }

    @Override
    public final synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.round = 0;
        this.typeUtils = processingEnv.getTypeUtils();
        this.elementUtils = processingEnv.getElementUtils();
        this.filer = processingEnv.getFiler();
        this.messager = processingEnv.getMessager();
        this.afterInit(processingEnv);
    }

    protected void afterInit(ProcessingEnvironment processingEnv) {
    }

    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        boolean result;
        if (!roundEnv.processingOver()) {
            try {
                result = this.onProcess(annotations, roundEnv);
            }
            catch (GenerationException e) {
                this.onError(e);
                result = true;
            }
        } else {
            try {
                result = this.onLastRound(roundEnv);
            }
            catch (GenerationException e) {
                this.onError(e);
                result = true;
            }
        }
        ++this.round;
        return result;
    }

    protected boolean onProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return true;
    }

    protected boolean onLastRound(RoundEnvironment roundEnv) {
        return true;
    }

    protected void onError(GenerationException e) {
        this.error(e);
    }

    protected int round() {
        return this.round;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    protected void code(String template, String packageName, String className, Supplier<Map<String, Object>> context) {
        StringBuffer code = this.generate(template, context);
        this.writeCode(packageName, className, code);
    }

    protected void resource(String template, String packageName, String resourceName, Supplier<Map<String, Object>> context) {
        StringBuffer code = this.generate(template, context);
        this.writeResource(packageName, resourceName, code);
    }

    protected StringBuffer generate(String template, Supplier<Map<String, Object>> context) {
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        try {
            Template t = this.config.getTemplate(template);
            t.process(context.get(), (Writer)bw);
        }
        catch (TemplateException | IOException ioe) {
            throw new GenerationException("Error generating template " + template + ": " + ioe.getMessage());
        }
        finally {
            try {
                bw.close();
                sw.close();
            }
            catch (IOException ioe) {
                throw new GenerationException("Error generating template " + template + ": " + ioe.getMessage());
            }
        }
        return sw.getBuffer();
    }

    protected void writeCode(String packageName, String className, StringBuffer code) {
        try {
            JavaFileObject jfo = this.filer.createSourceFile(packageName + "." + className, new Element[0]);
            Writer w = jfo.openWriter();
            BufferedWriter bw = new BufferedWriter(w);
            bw.append(code);
            bw.close();
            w.close();
        }
        catch (IOException e) {
            throw new GenerationException(String.format("Error writing code for %s.%s: %s", packageName, className, e.getMessage()));
        }
    }

    protected void writeResource(String packageName, String resourceName, StringBuffer content) {
        try {
            FileObject mf = this.filer.createResource(StandardLocation.SOURCE_OUTPUT, packageName, resourceName, new Element[0]);
            Writer w = mf.openWriter();
            BufferedWriter bw = new BufferedWriter(w);
            bw.append(content);
            bw.close();
            w.close();
        }
        catch (IOException e) {
            throw new GenerationException(String.format("Error writing content for %s.%s: %s", packageName, resourceName, e.getMessage()));
        }
    }

    protected void debug(String msg, Object ... args) {
        if (this.processingEnv.getOptions().containsKey("debug")) {
            this.messager.printMessage(Diagnostic.Kind.NOTE, String.format(msg, args));
        }
    }

    protected void info(String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, String.format(msg, args));
    }

    protected void warning(Element element, String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.WARNING, String.format(msg, args), element);
    }

    protected void error(String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args));
    }

    protected void error(GenerationException generationException) {
        if (generationException.getElement() != null) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, generationException.getMessage(), generationException.getElement());
        } else {
            this.messager.printMessage(Diagnostic.Kind.ERROR, generationException.getMessage());
        }
    }
}

