/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.cli;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jboss.dmr.ModelNode;
import org.jboss.hal.testsuite.cli.CliClient;
import org.jboss.hal.testsuite.cli.CliUtils;
import org.jboss.hal.testsuite.cli.DomainCliClient;
import org.jboss.hal.testsuite.cli.Library;
import org.jboss.hal.testsuite.cli.ServerManager;
import org.jboss.hal.testsuite.cli.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainManager
extends ServerManager {
    private static final Logger log = LoggerFactory.getLogger(DomainManager.class);

    public DomainManager(CliClient cliClient) {
        super(cliClient);
    }

    private String getDefaultHost() {
        if (!(this.cliClient instanceof DomainCliClient)) {
            throw new IllegalStateException("CLI client currently in use is not an instance of DomainCliClient");
        }
        String host = ((DomainCliClient)this.cliClient).getDomainHost();
        return host;
    }

    public String resolveExpression(String host, String expression) {
        String cmdTemplate = "/host=%s:resolve-expression(expression=\"%s\")";
        return this.cliClient.executeForResult(String.format(cmdTemplate, host, expression));
    }

    public String resolveExpression(String expression) {
        return this.resolveExpression(this.getDefaultHost(), expression);
    }

    public List<String> listHosts() {
        ArrayList<String> list = new ArrayList<String>();
        ModelNode response = this.cliClient.executeForResponse("/:read-children-names(child-type=host)");
        List hostNameList = response.get("result").asList();
        for (ModelNode hostName : hostNameList) {
            list.add(hostName.asString());
        }
        return list;
    }

    public List<String> listServers(String host) {
        ArrayList<String> list = new ArrayList<String>();
        List<ModelNode> servers = this.listServerNodes(host);
        for (ModelNode serverName : servers) {
            list.add(serverName.asString());
        }
        return list;
    }

    public List<String> listServers() {
        return this.listRunningServers(this.getDefaultHost());
    }

    public List<String> listRunningServers(String host) {
        ArrayList<String> list = new ArrayList<String>();
        List<ModelNode> serverList = this.listRunningServerNodes(host);
        for (ModelNode server : serverList) {
            list.add(server.asString());
        }
        return list;
    }

    public List<String> listRunningServers() {
        return this.listRunningServers(this.getDefaultHost());
    }

    public boolean isInRunningState(List<String> servers, String host) {
        ArrayList<String> remaining = new ArrayList<String>(servers);
        try {
            List<ModelNode> serverList = this.listRunningServerNodes(host);
            for (ModelNode server : serverList) {
                String state = server.get("server-state").asString();
                if (!state.equalsIgnoreCase("running")) {
                    return false;
                }
                remaining.remove(server.asString());
            }
            return remaining.isEmpty();
        }
        catch (IllegalStateException ex) {
            log.info("Unable to connect via CLI => host is probably down");
            return false;
        }
    }

    @Override
    public boolean isInRunningState() {
        return this.isInRunningState(this.getDefaultHost());
    }

    public boolean isInRunningState(String host) {
        try {
            return this.cliClient.readAttribute("/host=" + host, "host-state").equals("running");
        }
        catch (IllegalStateException ex) {
            log.info("Unable to read host state  via CLI => host might be down");
            return false;
        }
    }

    public List<String> listServerGroups(CliClient client) {
        ArrayList<String> list = new ArrayList<String>();
        ModelNode hostMasterResponse = client.executeForResponse("/:read-children-names(child-type=server-group)");
        List serverNameList = hostMasterResponse.get("result").asList();
        for (ModelNode serverName : serverNameList) {
            list.add(serverName.asString());
        }
        return list;
    }

    public boolean startServer(String host, String server, boolean block) {
        return this.manageServer(host, server, ":start", block);
    }

    public boolean stopServer(String host, String server, boolean block) {
        return this.manageServer(host, server, ":stop", block);
    }

    public Map<String, List<String>> listAllRunningServers() {
        HashMap<String, List<String>> running = new HashMap<String, List<String>>();
        for (String host : this.listHosts()) {
            List<String> servers = this.listRunningServers(host);
            if (servers.isEmpty()) continue;
            running.put(host, servers);
        }
        return running;
    }

    public void restoreDomainState(Map<String, List<String>> topology, boolean block) {
        for (String host : this.listHosts()) {
            List<String> servers = this.listServers(host);
            for (String server : servers) {
                if (topology.containsKey(host) && topology.get(host).contains(server)) {
                    this.startServer(host, server, block);
                    continue;
                }
                this.stopServer(host, server, block);
            }
        }
    }

    public boolean stopAllServers(Long sleepMillis) {
        boolean retValue = this.cliClient.executeForSuccess("/:stop-servers()");
        if (!retValue) {
            log.error("Operation stop-servers() wasn't successful");
        }
        if (retValue && sleepMillis != null) {
            Library.letsSleep(sleepMillis);
        }
        return retValue;
    }

    public boolean startAllServers(Long sleepMillis) {
        boolean retValue = this.cliClient.executeForSuccess("/:start-servers()");
        if (!retValue) {
            log.error("Operation start-servers() wasn't successful");
        }
        if (retValue && sleepMillis != null) {
            Library.letsSleep(sleepMillis);
        }
        return retValue;
    }

    public boolean restartAllServers(Long sleepMillis) {
        boolean retValue = this.cliClient.executeForSuccess("/:restart-servers()");
        if (!retValue) {
            log.error("Operation restart-servers() wasn't successful");
        }
        if (retValue && sleepMillis != null) {
            Library.letsSleep(sleepMillis);
        }
        return retValue;
    }

    public boolean removeServer(String host, String serverName) {
        return this.cliClient.executeForSuccess("/host=" + host + "/server-config=" + serverName + ":remove()");
    }

    public boolean removeServer(String serverName) {
        return this.removeServer(this.getDefaultHost(), serverName);
    }

    public boolean removeServerGroup(String groupName) {
        return this.cliClient.executeForSuccess("/server-group=" + groupName + ":remove()");
    }

    public boolean stopServerGroup(String groupName, Long sleepMillis) {
        String cmd = "/server-group=" + groupName + ":stop-servers()";
        boolean retValue = this.cliClient.executeForSuccess(cmd);
        if (!retValue) {
            log.error("Operation {} wasn't successful", (Object)cmd);
        }
        if (retValue && sleepMillis != null) {
            Library.letsSleep(sleepMillis);
        }
        return retValue;
    }

    public boolean startServerGroup(String groupName, Long sleepMillis) {
        String cmd = "/server-group=" + groupName + ":start-servers()";
        boolean retValue = this.cliClient.executeForSuccess(cmd);
        if (!retValue) {
            log.error("Operation {} wasn't successful", (Object)cmd);
        }
        if (retValue && sleepMillis != null) {
            Library.letsSleep(sleepMillis);
        }
        return retValue;
    }

    private boolean manageServer(String host, String server, String operation, boolean block) {
        String[] stringArray;
        if (block) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "block=true";
        } else {
            stringArray = null;
        }
        String[] params = stringArray;
        String cmd = CliUtils.buildCommand("/host=" + host + "/server-config=" + server, operation, params);
        boolean retValue = this.cliClient.executeForSuccess(cmd);
        if (!retValue) {
            log.error("Operation start() wasn't successful");
        }
        return retValue;
    }

    public List<ModelNode> listRunningServerNodes(String host) {
        ModelNode response = this.cliClient.executeForResponse("/host=" + host + ":read-children-names(child-type=server)");
        if (response.has("failure-description") && response.get("failure-description").asString().contains("JBAS014793")) {
            return Collections.emptyList();
        }
        return response.get("result").asList();
    }

    public List<ModelNode> listServerNodes(String host) {
        ModelNode response = this.cliClient.executeForResponse("/host=" + host + ":read-children-names(child-type=server-config)");
        return response.get("result").asList();
    }

    @Override
    public boolean waitUntilAvailable() {
        return this.waitUntilAvailable(this.getDefaultHost(), 60000L);
    }

    @Override
    public boolean waitUntilAvailable(long timeout) {
        return this.waitUntilAvailable(this.getDefaultHost(), timeout);
    }

    public boolean waitUntilAvailable(String host, long timeout) {
        long timePassed = 0L;
        boolean isRunning = false;
        long waitTimeInterval = 500L;
        while (timePassed < timeout && !isRunning) {
            isRunning = this.isInRunningState(host);
            if (isRunning) continue;
            log.info("Waiting for additional {} ms for server to get in running state (already waited for {} ms out of {} ms)", new Object[]{waitTimeInterval, timePassed, timeout});
            Library.letsSleep(waitTimeInterval);
            timePassed += waitTimeInterval;
        }
        return isRunning;
    }

    public void reloadIfRequiredAndWaitUntilRunning(long timeout) {
        if (this.isReloadRequired(this.listRunningServers(this.getDefaultHost()))) {
            this.reloadAndWaitUntilRunning(timeout);
        }
    }

    public void reloadAndWaitUntilRunning(long timeout) {
        List<String> all = this.listRunningServers(this.getDefaultHost());
        List<String> servers = this.filterAllRunningServers(all);
        this.reloadServers();
        this.waitUntilAvailable(timeout);
        this.waitUntilRunning(servers, timeout);
    }

    public void waitUntilRunning(List<String> servers, long timeout) throws TimeoutException {
        if (servers.isEmpty()) {
            log.debug("No servers for waiting were specified!");
        } else {
            int step = 500;
            long decTimeout = timeout;
            while (this.isServersRunning(servers)) {
                if (decTimeout <= 0L) {
                    throw new TimeoutException("Servers are not running in " + timeout);
                }
                decTimeout -= 500L;
                log.debug("Waiting another 500ms for server to become running.");
                Library.letsSleep(500L);
            }
        }
    }

    public List<String> filterNotStoppedOrSuspendedServers(List<String> servers) {
        return servers.stream().filter(server -> !this.isServerStoppedOrSuspended((String)server)).collect(Collectors.toList());
    }

    public boolean isServersRunning(List<String> servers) {
        return servers.stream().anyMatch(server -> !this.isServerRunning((String)server));
    }

    public boolean isServerRunning(String server) {
        return this.checkServerState(server, "running");
    }

    public List<String> filterAllRunningServers(List<String> servers) {
        LinkedList<String> running = new LinkedList<String>();
        for (String server : servers) {
            if (!this.checkServerStatus(server, "STARTED")) continue;
            running.add(server);
        }
        return running;
    }

    public boolean isReloadRequired(List<String> servers) {
        return servers.stream().anyMatch(this::isReloadRequiredForServerOnDomain);
    }

    public boolean isReloadRequiredForServerOnDomain(String server) {
        return this.checkServerState(server, "reload-required");
    }

    public boolean isRestartRequiredForServerOnDomain(String server) {
        return this.checkServerState(server, "restart-required");
    }

    public boolean isServerStoppedOrSuspended(String server) {
        return this.checkServerState(server, "stopped") || this.checkServerState(server, "suspended");
    }

    public void reloadServers() {
        this.cliClient.executeForSuccess(":reload-servers");
    }

    public boolean checkServerState(String server, String state) {
        String result = this.cliClient.executeForResult("/host=" + this.getDefaultHost() + "/server=" + server + ":read-attribute(name=server-state,include-defaults=true)");
        return result.toLowerCase().contains(state);
    }

    public boolean checkServerStatus(String server, String status) {
        String result = this.cliClient.executeForResult("/host=" + this.getDefaultHost() + "/server-config=" + server + ":read-attribute(name=status,include-defaults=true)");
        return result.equalsIgnoreCase(status);
    }
}

