/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.fragment.shared.util;

import java.util.List;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.hal.testsuite.fragment.BaseFragment;
import org.jboss.hal.testsuite.fragment.WindowFragment;
import org.jboss.hal.testsuite.fragment.shared.modal.ConfirmationWindow;
import org.jboss.hal.testsuite.fragment.shared.modal.WizardWindow;
import org.jboss.hal.testsuite.fragment.shared.table.ResourceTableFragment;
import org.jboss.hal.testsuite.fragment.shared.table.ResourceTableRowFragment;
import org.jboss.hal.testsuite.util.Console;
import org.jboss.hal.testsuite.util.PropUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class ResourceManager
extends BaseFragment {
    public ResourceTableFragment getResourceTable() {
        String cssClass = PropUtils.get("resourcetable.class");
        ByJQuery selector = ByJQuery.selector((String)("." + cssClass + ":visible"));
        WebElement tableRoot = this.getRoot().findElement((By)selector);
        ResourceTableFragment table = (ResourceTableFragment)Graphene.createPageFragment(ResourceTableFragment.class, (WebElement)tableRoot);
        return table;
    }

    public ResourceTableRowFragment selectByName(String name) {
        return this.getResourceTable().selectRowByText(0, name);
    }

    public <T extends WizardWindow> T addResource(Class<T> clazz, String label) {
        this.clickButton(label);
        T wizard = Console.withBrowser(this.browser).openedWizard(clazz);
        return wizard;
    }

    public <T extends WizardWindow> T addResource(Class<T> clazz) {
        String label = PropUtils.get("config.shared.add.label");
        return this.addResource(clazz, label);
    }

    public WizardWindow addResource() {
        return this.addResource(WizardWindow.class);
    }

    public <T extends WindowFragment> T removeResource(String name, Class<T> clazz) {
        this.selectByName(name);
        String label = PropUtils.get("config.shared.remove.label");
        this.clickButton(label);
        T window = Console.withBrowser(this.browser).openedWindow(clazz);
        return window;
    }

    public ConfirmationWindow removeResource(String name) {
        return this.removeResource(name, ConfirmationWindow.class);
    }

    public void removeResourceAndConfirm(String name) {
        ConfirmationWindow confirmationWindow = this.removeResource(name, ConfirmationWindow.class);
        confirmationWindow.confirm();
    }

    public void viewByName(String name) {
        ResourceTableRowFragment row = this.selectByName(name);
        row.view();
    }

    public List<String> listResources() {
        return this.getResourceTable().getTextInColumn(0);
    }
}

