/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.fragment.config.patching;

import org.jboss.arquillian.graphene.Graphene;
import org.jboss.hal.testsuite.fragment.config.patching.PatchResultPanelFragment;
import org.jboss.hal.testsuite.fragment.shared.modal.WizardWindow;
import org.jboss.hal.testsuite.util.PropUtils;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchingWizard
extends WizardWindow {
    private static final Logger log = LoggerFactory.getLogger(PatchingWizard.class);

    public void shutdownServer(boolean shutdown) {
        String identifier = PropUtils.get("runtime.patching.stopservers.radio");
        if (shutdown) {
            this.getEditor().radioButton(identifier, 0);
        } else {
            this.getEditor().radioButton(identifier, 1);
        }
    }

    public void restartSever(boolean restart) {
        String identifier = PropUtils.get("runtime.patching.restarthost.radio");
        if (restart) {
            this.getEditor().radioButton(identifier, 0);
        } else {
            this.getEditor().radioButton(identifier, 1);
        }
    }

    public PatchResultPanelFragment getResultPanel() {
        if (this.hasResultPanel()) {
            log.debug("Panel visible, creating result fragment");
            return (PatchResultPanelFragment)Graphene.createPageFragment(PatchResultPanelFragment.class, (WebElement)this.root.findElement(PatchResultPanelFragment.SELECTOR));
        }
        log.debug("No panel visible at this state");
        return null;
    }

    public boolean hasResultPanel() {
        return !this.root.findElements(PatchResultPanelFragment.SELECTOR).isEmpty();
    }

    public boolean isSuccess() {
        PatchResultPanelFragment p = this.getResultPanel();
        return p != null && p.isSuccessful();
    }

    public String getResultMessage() {
        PatchResultPanelFragment p = this.getResultPanel();
        if (p == null) {
            return null;
        }
        return p.isSuccessful() ? p.getMessage() : p.getErrorMessage() + "\nError details: " + p.getErrorDetails();
    }
}

