/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.page.config;

import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.hal.testsuite.finder.Application;
import org.jboss.hal.testsuite.finder.FinderNavigation;
import org.jboss.hal.testsuite.fragment.ConfigFragment;
import org.jboss.hal.testsuite.fragment.config.infinispan.CacheFragment;
import org.jboss.hal.testsuite.fragment.formeditor.Editor;
import org.jboss.hal.testsuite.page.ConfigPage;
import org.jboss.hal.testsuite.page.Navigatable;
import org.jboss.hal.testsuite.page.config.DomainConfigEntryPoint;
import org.jboss.hal.testsuite.page.config.StandaloneConfigEntryPoint;
import org.jboss.hal.testsuite.util.ConfigUtils;
import org.jboss.hal.testsuite.util.Console;
import org.jboss.hal.testsuite.util.PropUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class HibernateCachePage
extends ConfigPage
implements Navigatable {
    private static final By CONTENT = By.id((String)PropUtils.get("page.content.id"));

    @Override
    public void navigate() {
        FinderNavigation navigation = ConfigUtils.isDomain() ? new FinderNavigation(this.browser, DomainConfigEntryPoint.class).step("Configuration", "Profiles").step("Profile", "full") : new FinderNavigation(this.browser, StandaloneConfigEntryPoint.class).step("Configuration", "Subsystems");
        navigation.step("Subsystem", "Infinispan").step("Cache Container", "hibernate");
        navigation.selectRow().invoke("View");
        Application.waitUntilVisible(50);
        Console.withBrowser(this.browser).dismissReloadRequiredWindowIfPresent();
    }

    public CacheFragment content() {
        return (CacheFragment)Graphene.createPageFragment(CacheFragment.class, (WebElement)this.getContentRoot().findElement(CONTENT));
    }

    public CacheFragment local() {
        this.switchTab("Local Caches");
        return this.content();
    }

    public CacheFragment replicated() {
        this.switchTab("Replicated Caches");
        return this.content();
    }

    public CacheFragment distributed() {
        this.switchTab("Distributed Caches");
        return this.content();
    }

    public CacheFragment invalidation() {
        this.switchTab("Invalidation Caches");
        return this.content();
    }

    public boolean editTextAndSave(String identifier, String value) {
        ConfigFragment configFragment = this.getConfigFragment();
        Editor editor = configFragment.edit();
        editor.text(identifier, value);
        return configFragment.save();
    }

    public boolean selectOptionAndSave(String identifier, String value) {
        ConfigFragment configFragment = this.getConfigFragment();
        configFragment.edit().select(identifier, value);
        return configFragment.save();
    }

    public Boolean editCheckboxAndSave(String identifier, Boolean value) {
        ConfigFragment configFragment = this.getConfigFragment();
        configFragment.edit().checkbox(identifier, value);
        return configFragment.save();
    }

    public Boolean isErrorShownInForm() {
        ByJQuery selector = ByJQuery.selector((String)"div.form-item-error-desc:visible");
        return this.isElementVisible((By)selector);
    }

    private Boolean isElementVisible(By selector) {
        try {
            Graphene.waitAjax().until().element(selector).is().visible();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void selectCache(String name) {
        this.getResourceManager().selectByName(name);
    }
}

