/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.testlistener;

import java.io.IOException;
import java.util.Map;
import org.jboss.hal.testsuite.testlistener.ServerStateLoggerOperations;
import org.jboss.hal.testsuite.util.ConfigUtils;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerStateLogger
extends RunListener {
    private static final Logger log = LoggerFactory.getLogger(ServerStateLogger.class);
    private final ServerStateLoggerOperations ops = new ServerStateLoggerOperations();
    private Map<String, Map<String, String>> initServerStateMap;

    public void testRunStarted(Description description) throws Exception {
        if (ConfigUtils.isDomain()) {
            this.initServerStateMap = this.ops.getServerStateMap();
        }
    }

    public void testRunFinished(Result result) throws Exception {
        this.checkServerStateMap();
        this.checkRestartRequired();
        this.checkReloadRequired();
    }

    private void checkServerStateMap() throws IOException {
        Map<String, Map<String, String>> actualServerStateMap;
        if (ConfigUtils.isDomain() && !this.initServerStateMap.equals(actualServerStateMap = this.ops.getServerStateMap())) {
            log.warn("Server states don't equal initial ones! Expected '{}' but was '{}'.", this.initServerStateMap, actualServerStateMap);
        }
    }

    private void checkRestartRequired() throws IOException {
        if (this.ops.isRestartRequired()) {
            log.warn("Restart is required!");
        }
    }

    private void checkReloadRequired() throws IOException {
        if (this.ops.isReloadRequired()) {
            log.warn("Reload is required!");
        }
    }
}

