/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.util;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;

public class AvailablePortFinder {
    public static final int MIN_PORT_NUMBER = 1024;
    public static final int MAX_PORT_NUMBER = 65535;

    private AvailablePortFinder() {
    }

    private static Set<Integer> getAvailableTCPPorts() {
        return AvailablePortFinder.getAvailableTCPPorts(1024, 65535);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getNextAvailableTCPPort() {
        try (ServerSocket serverSocket = new ServerSocket(0);){
            int n = serverSocket.getLocalPort();
            return n;
        }
        catch (IOException ioe) {
            throw new NoSuchElementException(ioe.getMessage());
        }
    }

    private static int getNextAvailablePort(int fromPort) {
        if (fromPort < 1024 || fromPort > 65535) {
            throw new IllegalArgumentException("Invalid start port: " + fromPort);
        }
        for (int i = fromPort; i <= 65535; ++i) {
            if (!AvailablePortFinder.isPortFreeToUse(i)) continue;
            return i;
        }
        throw new NoSuchElementException("Could not find an unused port above " + fromPort);
    }

    private static boolean isPortFreeToUse(int port) {
        return AvailablePortFinder.isUDPPortFreeToUse(port) && AvailablePortFinder.isTCPPortFreeToUse(port);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isUDPPortFreeToUse(int port) {
        if (port < 1024) throw new IllegalArgumentException("Invalid start port: " + port);
        if (port > 65535) {
            throw new IllegalArgumentException("Invalid start port: " + port);
        }
        try (DatagramSocket ds = new DatagramSocket(port);){
            ds.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isTCPPortFreeToUse(int port) {
        if (port < 1024) throw new IllegalArgumentException("Invalid start port: " + port);
        if (port > 65535) {
            throw new IllegalArgumentException("Invalid start port: " + port);
        }
        try (ServerSocket ss = new ServerSocket(port);){
            ss.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static Set<Integer> getAvailableTCPPorts(int fromPort, int toPort) {
        if (fromPort < 1024 || toPort > 65535 || fromPort > toPort) {
            throw new IllegalArgumentException("Invalid port range: " + fromPort + " ~ " + toPort);
        }
        TreeSet<Integer> result = new TreeSet<Integer>();
        for (int i = fromPort; i <= toPort; ++i) {
            try (ServerSocket ignored = new ServerSocket(i);){
                result.add(i);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    public static int getNextAvailableNonPrivilegedPort() {
        int port = AvailablePortFinder.getNextAvailableTCPPort();
        if (AvailablePortFinder.isUDPPortFreeToUse(port)) {
            return port;
        }
        return AvailablePortFinder.getNextAvailablePort(1024);
    }
}

