/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.jboss.arquillian.graphene.page.Location;
import org.jboss.hal.testsuite.page.BasePage;
import org.jboss.hal.testsuite.util.PropUtils;

public class ConfigUtils {
    private static final Properties config = new Properties();

    public static String get(String key) {
        return config.getProperty(key);
    }

    public static String get(String key, String defval) {
        return config.getProperty(key, defval);
    }

    public static boolean isEAP() {
        return ConfigUtils.get("suite.server", "eap").toLowerCase().equals("eap");
    }

    public static boolean isDomain() {
        return ConfigUtils.get("suite.mode", "standalone").toLowerCase().equals("domain");
    }

    public static String getDistHome() {
        return ConfigUtils.get("jboss.dist");
    }

    public static String getDefaultProfile() {
        return ConfigUtils.get("suite.domain.default.profile", "full");
    }

    public static String getDefaultHost() {
        return ConfigUtils.get("suite.domain.default.host", "master");
    }

    public static URL getUrl() {
        try {
            URL url = new URL(System.getProperty("suite.url"));
            return url;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Invalid url", e);
        }
    }

    public static String getPageLocation(Class<? extends BasePage> page) {
        if (!page.isAnnotationPresent(Location.class)) {
            throw new IllegalArgumentException("Location annotation is not present on given page");
        }
        Location location = page.getAnnotation(Location.class);
        return location.value();
    }

    static {
        try (InputStream defaultConfig = PropUtils.class.getResourceAsStream("/suite.properties");){
            config.load(defaultConfig);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load suite configuration");
        }
        String customConfigLocation = System.getProperty("suite.config.location");
        if (customConfigLocation != null) {
            try (FileInputStream customConfig = new FileInputStream(customConfigLocation);){
                config.load(customConfig);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to load custom suite configuration");
            }
        }
        config.putAll((Map<?, ?>)System.getProperties());
    }
}

