/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.cli;

import org.jboss.as.cli.scriptsupport.CLI;
import org.jboss.hal.testsuite.cli.CliClient;
import org.jboss.hal.testsuite.cli.CliConfiguration;
import org.jboss.hal.testsuite.cli.CliUtils;
import org.jboss.hal.testsuite.cli.DomainManager;
import org.jboss.hal.testsuite.cli.Library;

public class DomainCliClient
extends CliClient {
    private final String profile;
    private final String domainHost;

    DomainCliClient(String profile) {
        this.profile = profile;
        this.domainHost = "master";
    }

    DomainCliClient(String profile, String domainHost) {
        this.profile = profile;
        this.domainHost = domainHost;
    }

    DomainCliClient(CliConfiguration cliConfig, String profile) {
        super(cliConfig);
        this.profile = profile;
        this.domainHost = "master";
    }

    DomainCliClient(CliConfiguration cliConfig, String profile, String host) {
        super(cliConfig);
        this.profile = profile;
        this.domainHost = host;
    }

    @Override
    public CLI.Result executeCommand(String command) {
        String updatedCommand = command;
        if (command.startsWith("/subsystem")) {
            updatedCommand = "/profile=" + this.profile + command;
        }
        if (command.startsWith("/core-service")) {
            updatedCommand = "/host=" + this.domainHost + command;
        }
        return super.executeCommand(updatedCommand);
    }

    @Override
    public void restart(boolean forced) {
        if (forced || this.restartRequired()) {
            this.restart();
        }
    }

    public boolean restartRequired(String host) {
        String result = this.readAttribute("/host=" + host, "host-state");
        return result.equals("restart-required");
    }

    @Override
    public boolean restartRequired() {
        return this.restartRequired(this.domainHost);
    }

    public boolean restart(String host) {
        String cmd = CliUtils.buildCommand("/host=" + host, ":shutdown", new String[]{"restart=true"});
        this.executeCommand(cmd);
        Library.letsSleep(1500L);
        DomainManager dm = new DomainManager(this);
        return dm.waitUntilAvailable();
    }

    @Override
    public boolean restart() {
        return this.restart(this.domainHost);
    }

    @Override
    public boolean reloadRequired() {
        return this.reloadRequired(this.domainHost);
    }

    @Override
    public boolean reload() {
        return this.reload(this.domainHost);
    }

    public boolean reloadRequired(String host) {
        String result = this.readAttribute("/host=" + host, "host-state");
        return result.equals("reload-required");
    }

    public boolean reload(String host) {
        String cmd = "/host=" + host + ":reload()";
        this.executeCommand(cmd);
        Library.letsSleep(500L);
        DomainManager dm = new DomainManager(this);
        return dm.waitUntilAvailable();
    }

    public String getDomainHost() {
        return this.domainHost;
    }
}

