/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.page.runtime;

import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.arquillian.graphene.page.Location;
import org.jboss.hal.testsuite.fragment.config.patching.PatchingWizard;
import org.jboss.hal.testsuite.fragment.config.patching.RestartWizard;
import org.jboss.hal.testsuite.fragment.shared.table.ResourceTableRowFragment;
import org.jboss.hal.testsuite.page.ConfigPage;
import org.jboss.hal.testsuite.util.PropUtils;
import org.openqa.selenium.By;

@Location(value="#patching")
public class PatchManagementPage
extends ConfigPage {
    public PatchingWizard applyNewPatch() {
        return this.addResource(PatchingWizard.class, PropUtils.get("runtime.patching.apply.label"));
    }

    public RestartWizard restartServer() {
        return this.addResource(RestartWizard.class, PropUtils.get("runtime.patching.restart.label"));
    }

    public PatchingWizard rollbackPatch(String patchId) {
        this.getResourceTable().selectRowByText(0, patchId);
        return this.addResource(PatchingWizard.class, PropUtils.get("runtime.patching.rollback.label"));
    }

    public ResourceTableRowFragment getLastPatchRow() {
        return this.getResourceManager().getResourceTable().getVisibleRow(0);
    }

    public boolean latestAppliedPatchLabelIsDisplayed() {
        ByJQuery lastPatchNameSelector = ByJQuery.selector((String)"h3:contains(Latest Applied Patch)");
        return this.getContentRoot().findElement((By)lastPatchNameSelector).isDisplayed();
    }

    public boolean latestAppliedPatchIsPendingRestart() {
        ByJQuery lastPatchCellSelector = ByJQuery.selector((String)"td>div:contains(Latest Applied Patch)");
        return this.getContentRoot().findElement((By)lastPatchCellSelector).getText().contains("Pending restart");
    }

    public String getLastPatchId() {
        return this.getLastPatchRow().getCellValue(0);
    }

    public String getLastPatchDate() {
        return this.getLastPatchRow().getCellValue(2);
    }

    public String getLastPatchType() {
        return this.getLastPatchRow().getCellValue(3);
    }
}

