/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.util;

import java.util.Map;
import org.jboss.dmr.ModelNode;
import org.jboss.hal.testsuite.cli.CliClient;
import org.jboss.hal.testsuite.cli.CliUtils;
import org.junit.Assert;

@Deprecated
public class ResourceVerifier {
    private String dmrPath;
    private CliClient cliClient;

    public ResourceVerifier(String dmrPath, CliClient cliClient) {
        if (cliClient == null) {
            throw new IllegalArgumentException("Management client not set.");
        }
        this.cliClient = cliClient;
        this.setDmrPath(dmrPath);
    }

    public void verifyResource(String dmrPath, boolean expected) {
        this.verifyResource(dmrPath, expected, 0);
    }

    public void verifyResource(String dmrPath, boolean expected, int timeout) {
        boolean exists = this.cliClient.executeForSuccess(dmrPath + ":read-resource()", timeout);
        if (expected) {
            Assert.assertTrue((String)("Resource " + dmrPath + " should exist"), (boolean)exists);
        } else {
            Assert.assertFalse((String)("Resource " + dmrPath + " should not exist"), (boolean)exists);
        }
    }

    public void verifyResource(boolean expected) {
        this.verifyResource(expected, 0);
    }

    public void verifyResource(boolean expected, int timeout) {
        if (this.dmrPath == null) {
            throw new IllegalStateException("DMR path not set");
        }
        this.verifyResource(this.dmrPath, expected, timeout);
    }

    public void verifyAttribute(String name, String expectedValue) {
        this.verifyAttribute(name, expectedValue, 0);
    }

    public void verifyAttribute(String name, String expectedValue, int timeout) {
        if (this.dmrPath == null) {
            throw new IllegalStateException("DMR path not set");
        }
        String dmrName = ResourceVerifier.camelToDash(name);
        String actualValue = this.cliClient.readAttribute(this.dmrPath, dmrName, timeout);
        Assert.assertEquals((String)"Attribute value is different in model.", (Object)expectedValue, (Object)actualValue);
    }

    public void verifyAttribute(String name, String[] expectedValues) {
        if (this.dmrPath == null) {
            throw new IllegalStateException("DMR path not set");
        }
        String dmrName = ResourceVerifier.camelToDash(name);
        Object[] actualValues = (String[])this.cliClient.executeForResponse(CliUtils.buildCommand(this.dmrPath, ":read-attribute", new String[]{"name=" + dmrName})).get("result").asList().stream().map(ModelNode::asString).toArray(String[]::new);
        Assert.assertArrayEquals((Object[])expectedValues, (Object[])actualValues);
    }

    public void verifyAttributes(Map<String, String> pairs) {
        for (Map.Entry<String, String> p : pairs.entrySet()) {
            this.verifyAttribute(p.getKey(), p.getValue());
        }
    }

    public void setDmrPath(String dmrPath) {
        this.dmrPath = dmrPath;
    }

    private static String camelToDash(String input) {
        return input.replaceAll("\\B([A-Z])", "-$1").toLowerCase();
    }
}

