/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.creaper;

import java.io.IOException;
import org.jboss.dmr.ModelNode;
import org.jboss.hal.testsuite.cli.Library;
import org.jboss.hal.testsuite.util.ConfigUtils;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.extras.creaper.core.online.ModelNodeResult;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.ReadAttributeOption;

public class ResourceVerifier {
    private static final Logger log = LoggerFactory.getLogger(ResourceVerifier.class);
    private static final int DEFAULT_TIMEOUT = Integer.parseInt(ConfigUtils.get("propagate.to.model.timeout", "500"));
    public static final int LONG_TIMEOUT = Integer.parseInt(ConfigUtils.get("propagate.to.model.timeout.long", "6000"));
    private Address resourceAddress;
    private Operations ops;
    private int timeout;

    public ResourceVerifier(Address resourceAddress, OnlineManagementClient client) {
        this(resourceAddress, client, DEFAULT_TIMEOUT);
    }

    public ResourceVerifier(Address resourceAddress, OnlineManagementClient client, int timeout) {
        this.resourceAddress = resourceAddress;
        this.ops = new Operations(client);
        this.timeout = timeout;
    }

    public ResourceVerifier verifyExists(String errorMessageSuffix) throws Exception {
        this.waitFor(() -> this.ops.exists(this.resourceAddress));
        Assert.assertTrue((String)("Resource '" + this.resourceAddress + "' should exist!" + errorMessageSuffix), (boolean)this.ops.exists(this.resourceAddress));
        return this;
    }

    public ResourceVerifier verifyExists() throws Exception {
        return this.verifyExists("");
    }

    public ResourceVerifier verifyDoesNotExist(String errorMessageSuffix) throws Exception {
        this.waitFor(() -> !this.ops.exists(this.resourceAddress));
        Assert.assertFalse((String)("Resource '" + this.resourceAddress + "' should NOT exist! " + errorMessageSuffix), (boolean)this.ops.exists(this.resourceAddress));
        return this;
    }

    public ResourceVerifier verifyDoesNotExist() throws Exception {
        return this.verifyDoesNotExist("");
    }

    public ResourceVerifier verifyAttribute(String attributeName, ModelNode expectedValue, String errorMessageSuffix) throws Exception {
        this.waitFor(() -> {
            ModelNodeResult actualResult = this.ops.readAttribute(this.resourceAddress, attributeName, new ReadAttributeOption[0]);
            return actualResult.isSuccess() && actualResult.hasDefinedValue() && expectedValue.equals(actualResult.value());
        });
        ModelNodeResult actualResult = this.ops.readAttribute(this.resourceAddress, attributeName, new ReadAttributeOption[0]);
        actualResult.assertDefinedValue();
        Assert.assertEquals((String)("Attribute value is different in model! " + errorMessageSuffix), (Object)expectedValue, (Object)actualResult.value());
        return this;
    }

    public ResourceVerifier verifyAttribute(String attributeName, ModelNode expectedValue) throws Exception {
        return this.verifyAttribute(attributeName, expectedValue, "");
    }

    public ResourceVerifier verifyAttribute(String attributeName, String expectedValue, String errorMessageSuffix) throws Exception {
        return this.verifyAttribute(attributeName, new ModelNode(expectedValue), errorMessageSuffix);
    }

    public ResourceVerifier verifyAttribute(String attributeName, String expectedValue) throws Exception {
        return this.verifyAttribute(attributeName, new ModelNode(expectedValue));
    }

    public ResourceVerifier verifyAttribute(String attributeName, boolean expectedValue, String errorMessageSuffix) throws Exception {
        return this.verifyAttribute(attributeName, new ModelNode(expectedValue), errorMessageSuffix);
    }

    public ResourceVerifier verifyAttribute(String attributeName, boolean expectedValue) throws Exception {
        return this.verifyAttribute(attributeName, new ModelNode(expectedValue));
    }

    public ResourceVerifier verifyAttribute(String attributeName, int expectedValue, String errorMessageSuffix) throws Exception {
        return this.verifyAttribute(attributeName, new ModelNode(expectedValue), errorMessageSuffix);
    }

    public ResourceVerifier verifyAttribute(String attributeName, int expectedValue) throws Exception {
        return this.verifyAttribute(attributeName, new ModelNode(expectedValue));
    }

    public ResourceVerifier verifyAttribute(String attributeName, long expectedValue, String errorMessageSuffix) throws Exception {
        return this.verifyAttribute(attributeName, new ModelNode(expectedValue), errorMessageSuffix);
    }

    public ResourceVerifier verifyAttribute(String attributeName, long expectedValue) throws Exception {
        return this.verifyAttribute(attributeName, new ModelNode(expectedValue));
    }

    public ResourceVerifier verifyAttributeNotEqual(String attributeName, ModelNode notExpectedValue) throws Exception {
        this.waitFor(() -> !this.attributeEquals(attributeName, notExpectedValue));
        Assert.assertFalse((String)(attributeName + " should not have value " + notExpectedValue), (boolean)this.attributeEquals(attributeName, notExpectedValue));
        return this;
    }

    private boolean attributeEquals(String attributeName, ModelNode expectedValue) throws IOException {
        ModelNodeResult actualResult = this.ops.readAttribute(this.resourceAddress, attributeName, new ReadAttributeOption[0]);
        return actualResult.isSuccess() && actualResult.hasDefinedValue() && actualResult.value().equals(expectedValue);
    }

    public ResourceVerifier verifyAttributeIsUndefined(String attributeName, String errorMessagePrefix) throws Exception {
        this.waitFor(() -> {
            ModelNodeResult actualResult = this.ops.readAttribute(this.resourceAddress, attributeName, new ReadAttributeOption[0]);
            return actualResult.isSuccess() && !actualResult.hasDefined("result");
        });
        this.ops.readAttribute(this.resourceAddress, attributeName, new ReadAttributeOption[0]).assertNotDefinedValue(errorMessagePrefix);
        return this;
    }

    public ResourceVerifier verifyAttributeIsUndefined(String attributeName) throws Exception {
        return this.verifyAttributeIsUndefined(attributeName, null);
    }

    private void waitFor(PropagationChecker checker) throws Exception {
        long start = System.currentTimeMillis();
        while (!checker.finallyPropagated() && System.currentTimeMillis() <= start + (long)this.timeout) {
            log.debug("Not yet propagated therefore waiting.");
            Library.letsSleep(100L);
        }
    }

    @FunctionalInterface
    private static interface PropagationChecker {
        public boolean finallyPropagated() throws Exception;
    }
}

