/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.fragment;

import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.arquillian.graphene.wait.IsElementBuilder;
import org.jboss.hal.testsuite.cli.Library;
import org.jboss.hal.testsuite.fragment.BaseFragment;
import org.jboss.hal.testsuite.fragment.formeditor.Editor;
import org.jboss.hal.testsuite.fragment.shared.util.ResourceManager;
import org.jboss.hal.testsuite.util.Console;
import org.jboss.hal.testsuite.util.PropUtils;
import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

public class ConfigFragment
extends BaseFragment {
    public ResourceManager getResourceManager() {
        return (ResourceManager)Graphene.createPageFragment(ResourceManager.class, (WebElement)this.root);
    }

    private By getEditButtonSelector() {
        return ByJQuery.selector((String)("." + PropUtils.get("configarea.edit.button.class") + ":visible"));
    }

    public WebElement getEditButton() {
        return this.root.findElement(this.getEditButtonSelector());
    }

    public boolean isInEditMode() {
        return this.isElementVisible(this.getEditButtonSelector()) == false;
    }

    public Editor edit() {
        WebElement button = this.getEditButton();
        button.click();
        ((IsElementBuilder)Graphene.waitGui().until().element(button).is().not()).visible();
        return this.getEditor();
    }

    public boolean save() {
        WebElement button = this.getButton(PropUtils.get("configarea.save.button.label"));
        if (!button.isDisplayed()) {
            Console.withBrowser(this.browser).pageDown();
            Library.letsSleep(100L);
        }
        button.click();
        try {
            Graphene.waitModel().until().element(this.getEditButton()).is().visible();
            return true;
        }
        catch (WebDriverException e) {
            return false;
        }
    }

    public void cancel() {
        this.clickButton(PropUtils.get("configarea.cancel.button.label"));
        Graphene.waitModel().until().element(this.getEditButton()).is().visible();
    }

    @Deprecated
    public void saveAndAssert(boolean expected) {
        boolean finished = this.save();
        if (expected) {
            Assert.assertTrue((String)"Config was supposed to be saved successfully, read view should be active.", (boolean)finished);
        } else {
            Assert.assertFalse((String)"Config wasn't supposed to be saved, read-write view should be active.", (boolean)finished);
        }
    }

    public boolean resourceIsPresent(String name) {
        long start = System.currentTimeMillis();
        while (this.getResourceManager().getResourceTable().getRowByText(0, name) == null) {
            if (System.currentTimeMillis() >= start + 2000L) {
                return false;
            }
            Library.letsSleep(200L);
        }
        return true;
    }

    public Boolean editTextAndSave(String identifier, String value) {
        this.edit().text(identifier, value);
        return this.save();
    }

    public Boolean editCheckboxAndSave(String identifier, Boolean value) {
        this.edit().checkbox(identifier, value);
        return this.save();
    }

    public Boolean selectOptionAndSave(String identifier, String value) {
        this.edit().select(identifier, value);
        return this.save();
    }

    public Boolean isErrorShownInForm() {
        ByJQuery selector = ByJQuery.selector((String)"div.form-item-error-desc:visible");
        return this.isElementVisible((By)selector);
    }

    private Boolean isElementVisible(By selector) {
        try {
            Graphene.waitAjax().until().element(selector).is().visible();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

