/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.fragment.config.datasource;

import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.hal.testsuite.fragment.config.datasource.TestConnectionWindow;
import org.jboss.hal.testsuite.fragment.shared.modal.WizardWindow;
import org.jboss.hal.testsuite.fragment.shared.table.ResourceTableFragment;
import org.jboss.hal.testsuite.fragment.shared.util.ResourceManager;
import org.jboss.hal.testsuite.util.Console;
import org.jboss.hal.testsuite.util.PropUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class DatasourceWizard
extends WizardWindow {
    private static final By DETECTED_DRIVER_BUTTON = By.xpath((String)".//div[text()='Detected Driver']");

    public TestConnectionWindow testConnection() {
        String label = PropUtils.get("config.datasources.configarea.connection.test.label");
        this.clickButton(label);
        Console.withBrowser(this.browser).waitUntilFinished();
        String windowTitle = PropUtils.get("config.datasources.window.connection.test.head.label");
        TestConnectionWindow window = Console.withBrowser(this.browser).openedWindow(windowTitle, TestConnectionWindow.class);
        return window;
    }

    public void switchToDetectedDriver() {
        this.root.findElement(DETECTED_DRIVER_BUTTON).click();
    }

    public ResourceTableFragment getResourceTable() {
        return ((ResourceManager)Graphene.createPageFragment(ResourceManager.class, (WebElement)this.root)).getResourceTable();
    }

    public DatasourceWizard selectTemplate(String templateLabel) {
        ByJQuery selectListItemSelector = ByJQuery.selector((String)(".choose_template:contains('" + templateLabel + "')"));
        this.getRoot().findElement((By)selectListItemSelector).findElement(By.tagName((String)"input")).click();
        return this;
    }

    public void selectDriver(String driverName) {
        this.getResourceTable().selectRowByText(0, driverName);
    }
}

