/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.fragment.formeditor;

import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.hal.testsuite.fragment.BaseFragment;
import org.jboss.hal.testsuite.fragment.shared.table.ResourceTableFragment;
import org.jboss.hal.testsuite.fragment.shared.table.ResourceTableRowFragment;
import org.jboss.hal.testsuite.util.Console;
import org.jboss.hal.testsuite.util.PropUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class PropertyEditor
extends BaseFragment {
    private ResourceTableFragment table;

    public void add(String key, String value) {
        ResourceTableRowFragment row = this.clickAddButton();
        this.setValue(row, value);
        this.setKey(row, key);
    }

    private ResourceTableRowFragment clickAddButton() {
        String cssClass = PropUtils.get("editor.shared.property.add.id");
        ByJQuery selector = ByJQuery.selector((String)("button[id$='" + cssClass + "']"));
        WebElement button = this.root.findElement((By)selector);
        button.click();
        this.waitForNewLine();
        Object row = this.getTable().getLastRow();
        return row;
    }

    private void waitForNewLine() {
        String emptyNameLabel = PropUtils.get("editor.shared.property.empty.key.label");
        String emptyValueLabel = PropUtils.get("editor.shared.property.empty.value.label");
        ByJQuery selector = ByJQuery.selector((String)("tr:contains('" + emptyNameLabel + "'):contains('" + emptyValueLabel + "')"));
        Graphene.waitGui().until().element((SearchContext)this.getTable().getRoot(), (By)selector);
    }

    private void setKey(ResourceTableRowFragment row, String text) {
        this.setTextValue(row, 0, text);
    }

    private void setValue(ResourceTableRowFragment row, String text) {
        this.setTextValue(row, 1, text);
    }

    private void setTextValue(ResourceTableRowFragment row, int index, String text) {
        WebElement cell = row.getCell(index);
        cell.click();
        ByJQuery selector = ByJQuery.selector((String)"input");
        Graphene.waitModel().until().element((SearchContext)cell, (By)selector).is().present();
        WebElement input = cell.findElement((By)selector);
        input.clear();
        input.sendKeys(new CharSequence[]{text});
        Graphene.waitGui().until().element(input).attribute("value").contains(text);
    }

    private ResourceTableFragment getTable() {
        if (this.table != null) {
            return this.table;
        }
        this.table = Console.withBrowser(this.browser).getTableByHeader("Key", ResourceTableFragment.class, this.root);
        return this.table;
    }
}

