/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.fragment.shared.layout;

import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.hal.testsuite.fragment.BaseFragment;
import org.jboss.hal.testsuite.fragment.PopUpFragment;
import org.jboss.hal.testsuite.fragment.WindowFragment;
import org.jboss.hal.testsuite.fragment.shared.modal.SettingsWindow;
import org.jboss.hal.testsuite.fragment.shared.modal.VersionInfoWindow;
import org.jboss.hal.testsuite.util.Console;
import org.jboss.hal.testsuite.util.PropUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebElement;

public class Footer
extends BaseFragment {
    @ArquillianResource
    private TakesScreenshot screenshot;

    public String getDisplayedVersion() {
        return this.getVersionInfoLink().getText();
    }

    public PopUpFragment openTools() {
        String label = PropUtils.get("footer.links.tools.label");
        this.getLink(label).click();
        Console console = Console.withBrowser(this.browser);
        PopUpFragment popup = console.openedPopup(PopUpFragment.class, PopUpFragment.ROOT_SELECTOR);
        return popup;
    }

    public SettingsWindow openSettings() {
        String label = PropUtils.get("footer.links.settings.label");
        this.getLink(label).click();
        Console console = Console.withBrowser(this.browser);
        SettingsWindow window = console.openedWindow(SettingsWindow.class);
        return window;
    }

    public VersionInfoWindow openVersionInfo() {
        this.getVersionInfoLink().click();
        Graphene.waitGui().until().element(WindowFragment.ROOT_SELECTOR).is().visible();
        return Console.withBrowser(this.browser).openedWindow(VersionInfoWindow.class);
    }

    private WebElement getVersionInfoLink() {
        String label = PropUtils.get("footer.version.label");
        ByJQuery selector = ByJQuery.selector((String)(".footer-link[title='" + label + "']"));
        WebElement version = this.root.findElement((By)selector);
        return version;
    }

    private WebElement getLink(String label) {
        ByJQuery selector = ByJQuery.selector((String)(".footer-link:contains('" + label + "')"));
        WebElement link = this.root.findElement((By)selector);
        return link;
    }
}

