/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.page.config;

import org.jboss.arquillian.graphene.page.Location;
import org.jboss.hal.testsuite.finder.Column;
import org.jboss.hal.testsuite.finder.FinderNavigation;
import org.jboss.hal.testsuite.finder.Row;
import org.jboss.hal.testsuite.fragment.config.datasource.DatasourceConfigArea;
import org.jboss.hal.testsuite.fragment.config.datasource.DatasourceWizard;
import org.jboss.hal.testsuite.fragment.config.datasource.PoolConfig;
import org.jboss.hal.testsuite.page.Navigatable;
import org.jboss.hal.testsuite.page.config.ConfigurationPage;
import org.jboss.hal.testsuite.page.config.DomainConfigurationPage;
import org.jboss.hal.testsuite.page.config.StandaloneConfigEntryPoint;
import org.jboss.hal.testsuite.util.ConfigUtils;
import org.jboss.hal.testsuite.util.Console;

@Location(value="#profiles/ds-finder")
public class DatasourcesPage
extends ConfigurationPage
implements Navigatable {
    private FinderNavigation NAVIGATION_TO_DATASOURCE_SUBSYSTEM_INSTANCE;

    @Override
    public DatasourceConfigArea getConfig() {
        return this.getConfig(DatasourceConfigArea.class);
    }

    @Override
    public DatasourceWizard addResource() {
        return this.addResource(DatasourceWizard.class);
    }

    @Deprecated
    public void switchToXA() {
        this.selectMenu("XA");
        Console.withBrowser(this.browser).waitUntilLoaded();
    }

    public DatasourceWizard getDatasourceWizard() {
        return Console.withBrowser(this.browser).openedWizard(DatasourceWizard.class);
    }

    public PoolConfig getPoolConfig() {
        return this.getConfig().switchTo("Pool", PoolConfig.class);
    }

    private FinderNavigation createNavigationToDatasourcesColumn() {
        if (this.NAVIGATION_TO_DATASOURCE_SUBSYSTEM_INSTANCE != null) {
            return this.NAVIGATION_TO_DATASOURCE_SUBSYSTEM_INSTANCE;
        }
        FinderNavigation navigation = ConfigUtils.isDomain() ? new FinderNavigation(this.browser, DomainConfigurationPage.class).step("Configuration", "Profiles").step("Profile", ConfigUtils.getDefaultProfile()) : new FinderNavigation(this.browser, StandaloneConfigEntryPoint.class).step("Configuration", "Subsystems");
        this.NAVIGATION_TO_DATASOURCE_SUBSYSTEM_INSTANCE = navigation.step("Subsystem", "Datasources");
        return this.NAVIGATION_TO_DATASOURCE_SUBSYSTEM_INSTANCE;
    }

    private void invokeActionOnDatasourceRow(Action action, DatasourceType type, String name) {
        Row row = this.createNavigationToDatasourcesColumn().step("Type", type.getTypeColumnLabel()).step(type.getFinalColumnLabel(), name).selectRow(true);
        Console.withBrowser(this.browser).dismissReloadRequiredWindowIfPresent();
        row.invoke(action.getActionLabel());
    }

    private void invokeActionOnDatasourceColumn(Action action, DatasourceType type) {
        Column column = this.createNavigationToDatasourcesColumn().step("Type", type.getTypeColumnLabel()).step(type.getFinalColumnLabel()).selectColumn();
        Console.withBrowser(this.browser).dismissReloadRequiredWindowIfPresent();
        column.invoke(action.getActionLabel());
    }

    @Override
    public void navigate() {
        this.createNavigationToDatasourcesColumn().selectColumn();
        Console.withBrowser(this.browser).waitUntilLoaded();
    }

    public void invokeAddDatasource() {
        this.invokeActionOnDatasourceColumn(Action.ADD, DatasourceType.NON_XA);
    }

    private static enum Action {
        VIEW("View"),
        ADD("Add");

        private String actionLabel;

        private Action(String actionLabel) {
            this.actionLabel = actionLabel;
        }

        public String getActionLabel() {
            return this.actionLabel;
        }
    }

    private static enum DatasourceType {
        XA("xa", "XA Datasource"),
        NON_XA("", "Datasource");

        private String typeColumnLabel;
        private String finalColumnLabel;

        private DatasourceType(String typeColumnLabel, String finalColumnLabel) {
            this.typeColumnLabel = typeColumnLabel;
            this.finalColumnLabel = finalColumnLabel;
        }

        public String getTypeColumnLabel() {
            return this.typeColumnLabel;
        }

        public String getFinalColumnLabel() {
            return this.finalColumnLabel;
        }
    }
}

