/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.page.config;

import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.arquillian.graphene.wait.IsElementBuilder;
import org.jboss.hal.testsuite.cli.Library;
import org.jboss.hal.testsuite.finder.Application;
import org.jboss.hal.testsuite.finder.FinderNavigation;
import org.jboss.hal.testsuite.finder.Row;
import org.jboss.hal.testsuite.fragment.ConfigFragment;
import org.jboss.hal.testsuite.fragment.WindowFragment;
import org.jboss.hal.testsuite.fragment.config.messaging.MessagingConfigArea;
import org.jboss.hal.testsuite.fragment.config.resourceadapters.ConfigPropertiesFragment;
import org.jboss.hal.testsuite.fragment.config.resourceadapters.ConfigPropertyWizard;
import org.jboss.hal.testsuite.fragment.formeditor.Editor;
import org.jboss.hal.testsuite.fragment.shared.modal.ConfirmationWindow;
import org.jboss.hal.testsuite.fragment.shared.util.ResourceManager;
import org.jboss.hal.testsuite.page.ConfigPage;
import org.jboss.hal.testsuite.page.Navigatable;
import org.jboss.hal.testsuite.page.config.DomainConfigEntryPoint;
import org.jboss.hal.testsuite.page.config.StandaloneConfigEntryPoint;
import org.jboss.hal.testsuite.util.ConfigUtils;
import org.jboss.hal.testsuite.util.Console;
import org.jboss.hal.testsuite.util.PropUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

public class MessagingPage
extends ConfigPage
implements Navigatable {
    protected static final String MESSAGING_PROVIDER_LABEL = "Messaging Provider";
    protected static final String MESSAGING_SUBSYSTEM_LABEL = "Messaging";
    protected static final String JMS_BRIDGE_LABEL = "JMS Bridge";
    protected static final String SETTINGS_LABEL = "Settings";
    private FinderNavigation navigation;

    @Override
    public ConfigFragment getConfigFragment() {
        WebElement editPanel = this.browser.findElement((By)ByJQuery.selector((String)".master_detail-detail:visible"));
        return (ConfigFragment)Graphene.createPageFragment(ConfigFragment.class, (WebElement)editPanel);
    }

    public ConfigFragment getWindowFragment() {
        WebElement editPanel = this.browser.findElement(By.className((String)"default-window-content"));
        return (ConfigFragment)Graphene.createPageFragment(ConfigFragment.class, (WebElement)editPanel);
    }

    public void navigateToMessagingProvider() {
        this.navigation = ConfigUtils.isDomain() ? new FinderNavigation(this.browser, DomainConfigEntryPoint.class).step("Configuration", "Profiles").step("Profile", ConfigUtils.getDefaultProfile()) : new FinderNavigation(this.browser, StandaloneConfigEntryPoint.class).step("Configuration", "Subsystems");
        this.navigation.step("Subsystem", MESSAGING_SUBSYSTEM_LABEL);
        this.navigation.step(SETTINGS_LABEL, MESSAGING_PROVIDER_LABEL);
    }

    public void selectProvider(String provider) {
        this.navigateToMessagingProvider();
        this.navigation.step(MESSAGING_PROVIDER_LABEL, provider);
    }

    public void navigateToMessaging() {
        this.selectProvider("default");
    }

    public void selectView(String view) {
        Row row = this.navigation.selectRow();
        Console.withBrowser(this.browser).dismissReloadRequiredWindowIfPresent();
        row.invoke(view);
        Application.waitUntilVisible();
    }

    public void selectConnectionsView() {
        this.selectView("Connections");
    }

    public void selectQueuesAndTopics() {
        this.selectView("Queues/Topics");
    }

    public void makeNavigation() {
        this.navigation.selectRow();
        Library.letsSleep(1000L);
    }

    public void createProvider(String name, boolean enabledSecurity, String secirityDomain, String clusterUser, String clusterPassword) {
        WebElement add = this.browser.findElement((By)ByJQuery.selector((String)"div.btn,.primary"));
        add.click();
        this.getWindowFragment().getEditor().text("name", name);
        this.getWindowFragment().getEditor().checkbox("security-enabled", enabledSecurity);
        this.getWindowFragment().getEditor().text("security-domain", secirityDomain);
        this.getWindowFragment().getEditor().text("cluster-user", clusterUser);
        this.getWindowFragment().getEditor().text("cluster-password", clusterPassword);
        this.getWindowFragment().clickButton("Save");
    }

    public void removeProvider() {
        this.navigation.selectRow().invoke("Remove");
        this.getWindowFragment().clickButton("Confirm");
    }

    public void invokeProviderSettings() {
        this.navigation.selectRow().invoke("Provider Settings");
        Library.letsSleep(1000L);
    }

    public void switchToSecurityTab() {
        WebElement security = this.browser.findElement((By)ByJQuery.selector((String)"div.gwt-Label:contains(Security)"));
        security.click();
    }

    public void switchToJournalTab() {
        WebElement security = this.browser.findElement((By)ByJQuery.selector((String)"div.gwt-Label:contains(Journal)"));
        security.click();
    }

    public void switchToConnectionManagementTab() {
        WebElement security = this.browser.findElement((By)ByJQuery.selector((String)"div.gwt-Label:contains(Connection Management):visible"));
        security.click();
    }

    public void switchToDiscovery() {
        this.switchView("Discovery");
    }

    public void switchToConnector() {
        this.switchView("Connector");
    }

    public void switchToAcceptor() {
        this.switchView("Acceptor");
    }

    public void switchToConnectorServices() {
        this.switchView("Connector Services");
    }

    public void switchToConnectionFactories() {
        this.switchView("Connection Factories");
    }

    public void switchToSecuritySettings() {
        this.switchView("Security Settings");
    }

    public void switchToAddressSettings() {
        this.switchView("Address Settings");
    }

    public void switchToConnections() {
        this.switchView("Connections");
    }

    public void switchToDiverts() {
        this.switchView("Diverts");
    }

    public void switchToBridges() {
        this.switchView("Bridges");
    }

    public void switchToJmsQueuesTopics() {
        this.switchView("JMS Queues/Topics");
    }

    public void selectInTable(String value, int column) {
        this.getResourceManager().getResourceTable().selectRowByText(column, value);
    }

    public void selectInTable(String text) {
        this.selectInTable(text, 0);
    }

    public void switchType(String type) {
        Select select = new Select(this.browser.findElement((By)ByJQuery.selector((String)".gwt-ListBox:visible")));
        select.selectByValue("Type: " + type);
    }

    public void switchToGenericType() {
        this.switchType("Generic");
    }

    public void switchToInVmType() {
        this.switchType("In-VM");
    }

    public void switchToRemoteType() {
        this.switchType("Remote");
    }

    public void addBridge(String name, String queue, String address, String connector) {
        this.clickButton("Add");
        WindowFragment window = Console.withBrowser(this.browser).openedWindow();
        Editor editor = window.getEditor();
        editor.text("name", name);
        editor.text("queueName", queue);
        editor.text("forwardingAddress", address);
        editor.text("staticConnectors", connector);
        window.clickButton("Save");
    }

    public void addBroadcastGroup(String name, String binding) {
        this.clickButton("Add");
        this.getWindowFragment().getEditor().text("name", name);
        this.getWindowFragment().getEditor().text("socket-binding", binding);
        this.getWindowFragment().clickButton("Save");
    }

    public void addRemoteAcceptor(String name, String socketBinding) {
        this.clickButton("Add");
        ConfigFragment windowFragment = this.getWindowFragment();
        Editor editor = windowFragment.getEditor();
        editor.text("name", name);
        editor.text("socketBinding", socketBinding);
        windowFragment.save();
    }

    public void addRemoteConnector(String name, String socketBinding) {
        this.addRemoteAcceptor(name, socketBinding);
    }

    public void addDiscoveryGroup(String name, String binding) {
        this.clickButton("Add");
        this.getWindowFragment().getEditor().text("name", name);
        this.getWindowFragment().getEditor().text("socketBinding", binding);
        this.getWindowFragment().clickButton("Save");
    }

    public void addInVmAcceptor(String name, String server) {
        this.clickButton("Add");
        this.getWindowFragment().getEditor().text("name", name);
        this.getWindowFragment().getEditor().text("serverId", server);
        this.getWindowFragment().clickButton("Save");
    }

    public void addGenericAcceptor(String name, String binding, String factoryClass) {
        this.clickButton("Add");
        this.getWindowFragment().getEditor().text("name", name);
        this.getWindowFragment().getEditor().text("socketBinding", binding);
        this.getWindowFragment().getEditor().text("factoryClass", factoryClass);
        this.getWindowFragment().clickButton("Save");
    }

    public void addDiverts(String name, String divert, String forward) {
        this.clickButton("Add");
        WindowFragment window = Console.withBrowser(this.browser).openedWindow();
        Editor editor = window.getEditor();
        editor.text("routingName", name);
        editor.text("divertAddress", divert);
        editor.text("forwardingAddress", forward);
        window.clickButton("Save");
    }

    public void addConnetorServices(String name, String factoryClass) {
        this.clickButton("Add");
        this.getWindowFragment().getEditor().text("name", name);
        this.getWindowFragment().getEditor().text("factoryClass", factoryClass);
        this.getWindowFragment().clickButton("Save");
    }

    public void addSecuritySettings(String pattern, String role) {
        this.clickButton("Add");
        this.getWindowFragment().getEditor().text("pattern", pattern);
        this.getWindowFragment().getEditor().text("role", role);
        this.getWindowFragment().clickButton("Save");
    }

    public void addAddressSettings(String pattern) {
        this.clickButton("Add");
        this.getWindowFragment().getEditor().text("pattern", pattern);
        this.getWindowFragment().clickButton("Save");
    }

    public void addQueue(String name, String jndiName) {
        this.clickButton("Add");
        ConfigFragment configFragment = this.getWindowFragment();
        Editor editor = configFragment.getEditor();
        editor.text("name", name);
        editor.text("entries", jndiName);
        configFragment.clickButton("Save");
    }

    public void addTopic(String name, String jndiName) {
        this.addQueue(name, jndiName);
    }

    public void addFactory(String name, String jndiName, String connector) {
        this.clickButton("Add");
        this.getWindowFragment().getEditor().text("name", name);
        this.getWindowFragment().getEditor().text("entries", jndiName);
        this.getWindowFragment().getEditor().text("connectors", connector);
        this.getWindowFragment().clickButton("Save");
    }

    public void addClusterConnection(String name, String dg, String connectorName, String connectorAddress) {
        this.clickButton("Add");
        this.getWindowFragment().getEditor().text("name", name);
        this.getWindowFragment().getEditor().text("discoveryGroup", dg);
        this.getWindowFragment().getEditor().text("connectorName", connectorName);
        this.getWindowFragment().getEditor().text("clusterConnectionAddress", connectorAddress);
        this.getWindowFragment().clickButton("Save");
    }

    public void clickAdvanced() {
        WebElement advanced = this.browser.findElement(By.linkText((String)"Advanced"));
        advanced.click();
    }

    public Editor edit() {
        WebElement button = this.getEditButton();
        button.click();
        ((IsElementBuilder)Graphene.waitGui().until().element(button).is().not()).visible();
        return this.getConfig().getEditor();
    }

    private WebElement getEditButton() {
        ByJQuery selector = ByJQuery.selector((String)("." + PropUtils.get("configarea.edit.button.class") + ":visible"));
        return this.getContentRoot().findElement((By)selector);
    }

    public void remove() {
        this.clickButton("Remove");
        try {
            Console.withBrowser(this.browser).openedWindow(ConfirmationWindow.class).confirmAndDismissReloadRequiredMessage();
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public void remove(String text) {
        this.selectInTable(text);
        this.remove();
    }

    @Override
    public MessagingConfigArea getConfig() {
        return this.getConfig(MessagingConfigArea.class);
    }

    public boolean addProperty(String key, String value) {
        ConfigPropertiesFragment properties = this.getConfig().propertiesConfig();
        ConfigPropertyWizard wizard = properties.addProperty();
        wizard.name(key).value(value).clickSave();
        Console.withBrowser(this.browser).dismissReloadRequiredWindowIfPresent();
        return wizard.isClosed();
    }

    public void removeProperty(String key) {
        ConfigPropertiesFragment config = this.getConfig().propertiesConfig();
        ResourceManager properties = config.getResourceManager();
        try {
            properties.removeResource(key).confirmAndDismissReloadRequiredMessage();
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }
}

