/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.cli;

import org.jboss.hal.testsuite.cli.CliClient;
import org.jboss.hal.testsuite.cli.CliConfiguration;
import org.jboss.hal.testsuite.cli.DomainCliClient;
import org.jboss.hal.testsuite.util.ConfigUtils;

public class CliClientFactory {
    private static final String FULL = "full";
    private static final String MANAGEMENT_ADDRESS = ConfigUtils.get("as.managementAddress");
    private static final int MANAGEMENT_PORT = Integer.parseInt(ConfigUtils.get("as.managementPort"));
    private static final CliConfiguration CLI_CONFIGURATION = new CliConfiguration(MANAGEMENT_ADDRESS, MANAGEMENT_PORT);

    public static CliClient getClient() {
        if (ConfigUtils.isDomain()) {
            return new DomainCliClient(CLI_CONFIGURATION, FULL);
        }
        return new CliClient(CLI_CONFIGURATION);
    }

    public static DomainCliClient getDomainClient(String profile) {
        return new DomainCliClient(CLI_CONFIGURATION, profile);
    }
}

