/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.creaper.command;

import org.jboss.hal.testsuite.util.ConfigUtils;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;

public class UndeployCommand
implements OnlineCommand {
    private final String deploymentName;
    private final boolean fromAllGroups;
    private final String particularGroup;

    private UndeployCommand(Builder builder) {
        this.deploymentName = builder.deploymentName;
        this.fromAllGroups = builder.fromAllGroups;
        this.particularGroup = builder.particularGroup;
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        StringBuilder cmd = new StringBuilder("undeploy ").append(this.deploymentName);
        if (ctx.options.isDomain) {
            if (this.fromAllGroups) {
                cmd.append(" --all-relevant-server-groups");
            } else {
                cmd.append("--server-groups").append(this.particularGroup);
            }
        }
        ctx.client.executeCli(cmd.toString());
    }

    public static final class Builder {
        private boolean fromAllGroups = false;
        private String particularGroup;
        private String deploymentName;

        public Builder(String deploymentName) {
            this.deploymentName = deploymentName;
        }

        public Builder fromAllGroups() {
            this.fromAllGroups = true;
            return this;
        }

        public Builder particularGroup(String groupName) {
            if (groupName != null && groupName.trim().isEmpty()) {
                throw new IllegalArgumentException("Group name should be neither empty nor whitespace!");
            }
            this.particularGroup = groupName;
            return this;
        }

        public UndeployCommand build() {
            if (ConfigUtils.isDomain()) {
                if (this.fromAllGroups == (this.particularGroup != null)) {
                    throw new IllegalArgumentException("In domain mode either nonempty particularGroup XOR fromAllGroups should be specified!");
                }
            } else if (this.fromAllGroups || this.particularGroup != null) {
                throw new IllegalArgumentException("In standalone mode neither particularGroup nor toAllGroups=true should be specified!");
            }
            return new UndeployCommand(this);
        }
    }
}

